/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: hw_timer.h,v 1.1 2008/06/17 00:04:35 suikan Exp $
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

#include <s_services.h>
#include "c54x.h"

#define INHNO_TIMER TINT0_VEC

#ifndef _MACRO_ONLY

#define TO_CLOCK(nume,deno) (TIMER_CLOCK * (nume) / (deno))
#define TO_USEC(clock)       ((clock) * 1000 / TIMER_CLOCK)

#define MAX_CLOCK ((CLOCK) 0xffff)

#define GET_TOLERANCE 100

#define BEFORE_IREQ(clock) \
  ((clock) >= TO_CLOCK(TIC_NUME, TIC_DENO) - GET_TOLERANCE)


typedef UH CLOCK;

Inline void
hw_timer_initialize()
{
	CLOCK	c = TO_CLOCK(TIC_NUME,TIC_DENO);

	/* 0.25 secŃJEg */
	sil_wrh_mem((VP) TMU0_TCR, TCR_TSS | 0x0009);
//	sil_wrh_mem((VP) TMU0_TCR, TCR_TSS | 0x0001);
	/* JE^̐ݒ */
	sil_wrh_mem((VP) TMU0_PRD, c - 1);
	/* _EJE^̏lݒ */
	sil_wrh_mem((VP) TMU0_TCR, (sil_reh_mem((VP) TMU0_TCR) | TCR_TRB));
	/* ^C}̋N */
	sil_wrh_mem((VP) TMU0_TCR, (sil_reh_mem((VP) TMU0_TCR) & ~TCR_TSS));

	sil_wrh_mem((VP) IFR, (sil_reh_mem((VP) IFR) | (0x1 << TINT0)));
	sil_wrh_mem((VP) IMR, (sil_reh_mem((VP) IMR) | (0x1 << TINT0)));
}

Inline void
hw_timer_int_clear()
{
}

Inline void
hw_timer_terminate()
{
	sil_wrh_mem((VP) TMU0_TCR, (sil_reh_mem((VP) TMU0_TCR) | TCR_TSS));
	sil_wrh_mem((VP) IMR, (sil_reh_mem((VP) IMR) & ~(0x1 << TINT0)));
	sil_wrh_mem((VP) IFR, (sil_reh_mem((VP) IFR) | (0x1 << TINT0)));
}

Inline CLOCK
hw_timer_get_current(void)
{
	return(TO_CLOCK(TIC_NUME,TIC_DENO) - sil_reh_mem((VP) TMU0_TIM));
}

Inline BOOL
hw_timer_fetch_interrupt(void)
{
	return(sil_reh_mem((VP) IFR) & (0x1 << TINT0));
}

#endif /* _MACRO_ONLY */
#endif /* _HW_TIMER_H_ */
