/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: tl16c550cfn.h,v 1.1 2008/06/17 00:04:46 suikan Exp $
 */

/*
 * TL16C550CFNp ȈSIOhCo
 */
#ifndef _TL16C550CFN_H_
#define _TL16C550CFN_H_

#include <t_config.h>

/***********************************************
 *  I/O  E}bvhEWX^            *
***********************************************/
/*
 *  complex Programmable Logic Device (CPLD)   *
 *  I/O E}bvhEWX^                 *
 */

/*  WX^@AhX@*/
#ifndef _MACRO_ONLY
volatile ioport UH	port0;
volatile ioport UH	port1;
volatile ioport UH	port2;
volatile ioport UH	port3;
volatile ioport UH	port4;
volatile ioport UH	port5;
volatile ioport UH	port6;
#endif /* _MACRO_ONLY */

/*  CPLD@WX^ */
#define CPLD_CTRL1	port0
#define CPLD_STAT	port1
#define CPLD_DMCTRL	port2
#define CPLD_DBIO	port3
#define CPLD_CTRL2	port4
#define CPLD_SEM0	port5
#define CPLD_SEM1	port6

/*
 *  UART I/O E}bvhEWX^ *
 */
/*  WX^ AhX */
#ifndef _MACRO_ONLY
volatile ioport UH	port4000;
volatile ioport UH	port4001;
volatile ioport UH	port4002;
volatile ioport UH	port4003;
volatile ioport UH	port4004;
volatile ioport UH	port4005;
volatile ioport UH	port4006;
volatile ioport UH	port4007;
#endif /* _MACRO_ONLY */

/*  UART WX^  */
#define UART_RBR	port4000
#define UART_THR	port4000
#define UART_IER	port4001
#define UART_IIR	port4002
#define UART_FCR	port4002
#define UART_LCR	port4003
#define UART_MCR	port4004
#define UART_LSR	port4005
#define UART_MSR	port4006
#define UART_SCR	port4007
/*
 *  ȉ̃WX^ɃANZXOɁA
 *  DLAB=1 (b7 of LCR) ZbgKv
 */
#define UART_DLL	port4000
#define UART_DLM	port4001

/*
 *  rbgtB[h̒`
 */
#define FCR_FIFO	0x01
#define FCR_RFRST	0x02
#define FCR_TFRST	0x04
#define FIFO_TRIG	0x00

#define LCR_DLAB	0x80

/* MM荞݂̒` */
#define IER_ERBI	0x01  /* M荞 */
#define IER_RIE		IER_ERBI 
#define IER_ETBEI	0x02  /* M荞 */
#define IER_TIE		IER_ETBEI

#define LSR_DR		0x01
#define LSR_THRE	0x20
#define LSR_TEMT	0x40

#define IIR_RXINT	0x04
#define IIR_TXINT	0x02

/*
 *  UART̃{[[g̐ݒ
 */
/*
 * BAUD RATE 2 : 115200 bps
 * BAUD RATE 4 : 57600  bps
 */
#define UART_BAUD_RATE    2



#ifndef _MACRO_ONLY

/*
 *  VAI/O|[gubN
 */
typedef struct sio_port_initialization_block {
	VP	dummy;
} SIOPINIB;

/*
 *  VAI/O|[gǗubN
 */
typedef struct sio_port_control_block {
	const SIOPINIB	*siopinib;  /* VAI/O|[gubN */
	VP_INT	exinf;			/* g */
	BOOL	openflag;		/* I[vς݃tO */
	BOOL	getready;		/* M */
	BOOL	putready;		/* Mł */
} SIOPCB;

/*
 *  R[obN[`̎ʔԍ
 */
#define SIO_ERDY_SND    1u              /* M\R[obN */
#define SIO_ERDY_RCV    2u              /* MʒmR[obN */

/*
 * J[lNp̏(sys_putcgp邽)
 */
extern void	uart_init(void);

/*
 *  SIOhCȍ[`
 */
extern void	uart_initialize(void);

/*
 *  I[vĂ|[g邩H
 */
extern BOOL	uart_openflag(void);

/*
 *  VAI/O|[g̃I[v
 */
extern SIOPCB	*uart_opn_por(ID siopid, VP_INT exinf);

/*
 *  VAI/O|[g̃N[Y
 */
extern void	uart_cls_por(SIOPCB *siopcb);

/*
 *  VAI/O|[gւ̕M
 */
extern BOOL	uart_snd_chr(SIOPCB *siopcb, char chr);

/*
 *  VAI/O|[g̕M
 */
extern INT	uart_rcv_chr(SIOPCB *siopcb);

/*
 *  VAI/O|[g̃R[obN̋
 */
extern void	uart_ena_cbr(SIOPCB *siopcb, UINT cbrtn);

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
extern void	uart_dis_cbr(SIOPCB *siopcb, UINT cbrtn);

/*
 *  SIO̊݃T[rX[`
 */
extern void	uart_isr(void);

/*
 *  VAI/O|[g̑M\R[obN
 */
extern void	uart_ierdy_snd(VP_INT exinf);

/*
 *  VAI/O|[g̎MʒmR[obN
 */
extern void	uart_ierdy_rcv(VP_INT exinf);

/* |[OŃVAɑM */
Inline char
uart_putc(char c)
{
	while ((UART_LSR & LSR_THRE) == 0);      /*  MWX^󂩂ǂ  */
	UART_THR = c;
	return(c);
}

#endif /* _MACRO_ONLY */

#endif /* _TL16C550CFN_H_ */
