/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: cpu_config.h,v 1.1 2008/06/17 00:04:35 suikan Exp $
 */


/*
 *  vZbTˑW[iSH3/4pj
 *  ̃CN[ht@ĆCt_config.h ݂̂CN[hD
 *  ̃t@C璼ڃCN[hĂ͂ȂȂD
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_


/*
 *  J[lʖ̃l[
 */
#include <cpu_rename.h>


#ifdef SH4
#include <sh4.h>        
#else  /* SH3 */
#include <sh3.h>        
#endif /* SH4 */


/*
 *  ݒ\ȍōDx
 */
#ifdef GDB_STUB
#define MAX_IPM  0xe
#else
#define MAX_IPM  0xf
#endif 


/*
 *  vZbT̓ꖽ߂̃CC֐`
 */
#ifndef _MACRO_ONLY
#include <cpu_insn.h>
#endif /* _MACRO_ONLY */

/*
 *  chg_ipm/get_ipm T|[g邩ǂ̒`
 */
#define	SUPPORT_CHG_IPM



/*
 *  TCB ֘A̒`
 *
 *  cpu_context.h ɓGKgCQƂ̈ˑ̊֌WŁC
 *  cpu_context.h ɂ͓ȂD
 */

/*
 *  TCB ̃tB[h̃rbg̒`
 */
#define	TBIT_TCB_PRIORITY	8	/* priority tB[h̃rbg */
#define	TBIT_TCB_TSTAT		8	/* tstat tB[h̃rbg */

#ifndef _MACRO_ONLY
/*
 *  ^XNReLXgubN̒`
 */
typedef struct task_context_block {
        VP	sp;             /* X^bN|C^ */
        FP  pc;             /* vOJE^ */
} CTXB;

/*
 *  ݃}XN색Cu
 *
 *  ݃}XNiintmaskj́CIPMiInterrupt Priority Maskj4rbg
 *  ɃVtĝłD
 */


/*
 *  ݂̊݃}XN̓Ǐo
 */
Inline UW
current_intmask()
{
	return(current_sr() & 0x000000f0);
}


/*
 *  ݃}XN̐ݒ
 */
Inline void
set_intmask(UW intmask)
{
	set_sr((current_sr() & ~0x000000f0) | intmask);
}


/*
 *  VXeԎQ
 */

Inline BOOL
sense_context()
{
    UW  nest;
    Asm("stc r7_bank,%0":"=r"(nest));
        
	return(nest > 0);    
}


Inline BOOL
sense_lock()
{
	return(current_intmask() == MAX_IPM << 4);
}


#define t_sense_lock	sense_lock
#define i_sense_lock	sense_lock


/*
 *  CPUbNƂ̉i^XNReLXgpj
 *
 *  task_intmask ́Cchg_ipm T|[g邽߂̕ϐDchg_ipm T|[
 *  gȂꍇɂ́Ct_unlock_cpu  task_intmask  0 ɒu
 *  悢D
 */

#ifdef SUPPORT_CHG_IPM
extern UW	task_intmask;	/* ^XNReLXgł̊݃}XN */
#endif /* SUPPORT_CHG_IPM */


Inline void
t_lock_cpu()
{
	disint();
}


Inline void
t_unlock_cpu()
{
#ifdef SUPPORT_CHG_IPM
	/*
	 *  t_unlock_cpu Ăяô CPUbNԂ݂̂ł邽
	 *  ߁C̓r task_intmask 邱Ƃ͂ȂD
	 */
	set_intmask(task_intmask);
#else /* SUPPORT_CHG_IPM */
	enaint();
#endif /* SUPPORT_CHG_IPM */
}


/*
 *  CPUbNƂ̉i^XNReLXgpj
 */

extern UW	int_intmask;	/* ^XNReLXgł̊݃}XN */

Inline void
i_lock_cpu()
{
	UW	intmask;

	/*
	 *  ꎞϐ intmask gĂ̂́Ccurrent_intmask()Ă
	 *  Ɋ݂CNꂽ݃nh
	 *  int_intmask ύX\邽߂łD
	 */
	intmask = current_intmask();
	disint();
	int_intmask = intmask;
}


Inline void
i_unlock_cpu()
{
	set_intmask(int_intmask);
}


/*
 *  ^XNfBXpb`
 */

/*
 *  ōD揇ʃ^XNւ̃fBXpb`icpu_support.Sj
 *
 *  dispatch ́C^XNReLXgĂяoꂽT[rXR[
 *  ŁCCPUbNԂŌĂяoȂ΂ȂȂD
 */
extern void	dispatch(void);


/*
 *  ݂̃ReLXĝĂăfBXpb`icpu_support.Sj
 *
 *  exit_and_dispatch ́CCPUbNԂŌĂяoȂ΂ȂȂD
 */
extern void	exit_and_dispatch(void);


/*
 *  ݃nh^CPUOnh̐ݒ
 */

/*
 *  xN^x[X̒`
 */
extern void   BASE_VBR(void);


/*
 *  OxN^e[u̍\̒`
 */
typedef struct exc_vector_entry {
	FP	exchdr;			/* Onh̋NԒn */
} EXCVE;



/*
 *  荞݃nh̋^e[u
 *  SH3ȍ~̓xN^e[uȂߊ荞ݏŗOv
 *  ItZbgɂ^e[unh̎sԒny
 *  荞݃}XN̒l擾
 */
extern FP	int_table[];
extern VW   int_plevel_table[];


/*
 *  CPUOnh̋^e[u
 */
extern FP	exc_table[(0x1E0 >> 5) + 1];


/*
 *
 *  ݃nh̐ݒ
 *
 *  xNgԍ inhno ̊݃nh̋NԒn inthdr ɐݒ肷D
 *  ^e[uɓo^
 *  stubgꍇstubĂяoɂstubɓo^
 *  
 */

extern FP general_exception();
extern FP interrupt();


Inline void
define_inh(INHNO inhno, FP inthdr)
{
        int_table[inhno >> 5] = inthdr;
#ifdef GDB_STUB
        Asm("mov #0x8,r0;  mov %0,r4; mov %1,r5; trapa #0x3f"
	    : /* no output */
	    : "r"(inhno),"r"(interrupt)
	    : "r0", "r4", "r5");
#endif /* GDB_STUB */
}


/*
 *   CPUOnh̐ݒ
 *   [xN^[e[uɓo^
 */   
Inline void
define_exc(EXCNO excno, FP exchdr)
{
        exc_table[excno >> 5] = exchdr;
#ifdef  GDB_STUB 
        Asm("mov #0x8,r0;  mov %0,r4; mov %1,r5;  trapa #0x3f"
	    : /* no output */
	    : "r"(excno),"r"(general_exception)
	    : "r0", "r4", "r5");
#endif /* GDB_STUB */
}


/*
 *  荞݃x̐ݒ
 */
Inline void
define_int_plevel(UINT dintno, UW plevel)
{
    int_plevel_table[dintno >> 5] = (plevel << 4) | 0x40000000;
}


/*
 *  ݃nh^CPUOnh̏o
 *  
 */

/*
 *  ݃nh̏o̐}N
 */

#define	INTHDR_ENTRY(inthdr)  extern void inthdr(void)

#define INT_ENTRY(inthdr) inthdr

/*
 *  CPUOnh̏o̐}N
 *
 */
#define	EXCHDR_ENTRY(exchdr)  extern void exchdr(VP sp)

#define	EXC_ENTRY(exchdr)     exchdr


/*
 *  CPUO̔̃VXeԂ̎Q
 */

/*
 *  CPUO̔̃ReLXg
 */
Inline BOOL
exc_sense_context(VP p_excinf)
{
    UW  nest;
    Asm("stc r7_bank,%0":"=r"(nest));
        
	return(nest > 1);
}


/*
 *  CPUO̔CPUbNԂ̎Q
 */
Inline BOOL
exc_sense_lock(VP p_excinf)
{
	return((*((UW *)p_excinf + 11) & 0x00000f0) == MAX_IPM << 4);
}


/*
 *  vZbTˑ̏
 */
extern void	cpu_initialize(void);


/*
 *  vZbTˑ̏I
 */
extern void	cpu_terminate(void);


/*
 * o^̊/ÕOo
 */
extern void     cpu_expevt(VW,VW,VW,VW);
extern void     cpu_interrupt(VW,VW,VW,VW);
extern void     no_reg_interrupt(void);


/*
 *  VARg[̃{[[gݒ莞̑҂Ԃ̐ݒ
 *  oXXe[gRg[̃tbVJE^g
 */
#define WAIT_RFCR_FOR_SCI    200

/*
 *  gdb stubɂo
 */
Inline int
stub_putc(int c)
{
  Asm("mov #0x00,r0; mov %0,r4; trapa #0x3f"
               : /* no output */
               : "r"(c)
               : "r0","r4");
  return(c);
}


#endif /* _MACRO_ONLY_ */
#endif /* _CPU_CONFIG_H_ */
