/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *                     2003         by Advanced Data Controls, Corp
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: sys_config.c,v 1.1 2008/06/17 00:04:58 suikan Exp $
 */


#include "jsp_kernel.h"
#include <ms7727cp01.h>
#include <st16c2550.h>

/*
 *  ^[QbgVXeˑ [`
 */
void
sys_initialize()
{
    /* PINT7 HightxŎt */
    sil_wrh_mem((VP)ICR2,
                (sil_reh_mem((VP)ICR2) | ICR2_PINT7S));

    /* PINT6 HightxŎt */
    sil_wrh_mem((VP)ICR2,
                (sil_reh_mem((VP)ICR2) | ICR2_PINT6S));    
    
    /*
     * R\[p̃VARg[̏
     */
    st16c2550_init();
}


/*
 *  ^[QbgVXȅI[`
 *
 *  VXeI鎞ɎgDʏ̓j^ĂяoŎD
 *  
 */
void
sys_exit(void)
{
    kernel_abort();
}

/*
 *   VXeo͐̎w
 */

#ifdef MULTI_IO
#include <stdio.h>
#define SYS_PUT_CHAR(c) putchar(c)
#else 
#define SYS_PUT_CHAR(c) st16c2550_pol_putc(c,LOGTASK_PORTID)
#endif /* GDB_STUB */


void
sys_putc(char c)
{
    if (c == '\n') {
        SYS_PUT_CHAR('\r');
    }
    SYS_PUT_CHAR(c);
}


