/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002-2004 by Hokkaido Industrial Research Institute, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: sh7615scif.h,v 1.1 2008/06/17 00:04:40 suikan Exp $
 */

/*
 *   SH2VAR~jP[VC^tF[XSCIp ȈՃhCo
 */

#ifndef _SH2SCIF_H_
#define _SH2SCIF_H_

#include <t_config.h>

/*
 *  VAI/O|[gubN
 */
typedef struct sio_port_initialization_block
{
	UW reg_base;				/* WX^̃x[XAhX */
	UB brr;						/* {[[g̐ݒl   */
	UB smr;						/* [hWX^̐ݒl   */
	UB int_level;				/* 荞݃x̐ݒl   */
} SIOPINIB;

/*
 *  VAI/O|[gǗubN
 */
typedef struct sio_port_control_block
{
	const SIOPINIB *siopinib;	/* VAI/O|[gubN */
	VP_INT exinf;				/* g */
	BOOL openflag;				/* I[vς݃tO */
	BOOL sendflag;				/* M݃Cl[utO */
	BOOL getready;				/* M */
	BOOL putready;				/* 𑗐Mł */
} SIOPCB;

#if defined(TTM)
/*
 *  Rg[WX^̃AhX 
 */
#define SCIF_SC1SSR	(VH *)0xfffffcc8
#define SCIF_SC2SSR	(VB *)0xfffffcca
#define SCIF_SCFRDR	(VB *)0xfffffccc
#define SCIF_SCFTDR	(VB *)0xfffffcc6
#define SCIF_SCSCR	(VB *)0xfffffcc4
#define SCIF_SCFCR	(VB *)0xfffffcce
#define SCIF_SCSMR	(VB *)0xfffffcc0
#define SCIF_SCBRR	(VB *)0xfffffcc2
#endif
/*
 *  Rg[WX^̃AhX̃ItZbg 
 */
#define SCIF_SC1SSR	0x08
#define SCIF_SC2SSR	0x0a
#define SCIF_SCFRDR	0x0c
#define SCIF_SCFTDR	0x06
#define SCIF_SCSCR	0x04
#define SCIF_SCFCR	0x0e
#define SCIF_SCSMR	0x00
#define SCIF_SCBRR	0x02

/*
 *  Rg[WX^̐ݒl
 */
/*  FIFORg[WX^SCFCR̃rbg  */
#define SCFCR_TFRST	0x04		/* gX~bgFIFOf[^WX^Zbg */
#define SCFCR_RFRST	0x02		/* V[uFIFOf[^WX^Zbg */
/*  VARg[WX^SCSCR̃rbg  */
#define SCSCR_TIE	0x80		/* gX~bgC^vgCl[u */
#define SCSCR_RIE	0x40		/* V[uC^vgCl[u   */
#define SCSCR_TE	0x20		/* gX~bgCl[u         */
#define SCSCR_RE	0x10		/* V[uCl[u           */
/*  VAXe[^XWX^SC1SSR̃rbg  */
#define SC1SSR_TDFE	0x0020		/* gX~bgFIFOf[^WX^GveB */
#define SC1SSR_ER	0x0080		/* V[uG[       */
#define SC1SSR_FER	0x0008		/* t[~OG[       */
#define SC1SSR_PER	0x0004		/* peBG[       */
#define SC1SSR_RDRF	0x0002		/* V[uf[^WX^t       */
#define SC1SSR_BRK	0x0010		/* u[No */
/*  VAXe[^XWX^SC2SSR̃rbg  */
#define SC2SSR_ORER	0x01		/* I[o[G[ */

#define sh2scif_DELAY 	105000


/*
 *  SCI̐ݒ
 */
#define SMR_CKS 	0x0			/*            */
#define BRR9600 	47			/*  9600 rbg[g    */
#define BRR19200	23			/*  19200 rbg[g    */
#define BRR38400	11			/*  38400 rbg[g    */
#define BRR57600 	7			/*  57600 rbg[g 	*/
#define BRR115200 	3			/*  115200 rbg[g */

/*
 *  R[obN[`̎ʔԍ
 */
#define SIO_ERDY_SND	1u		/* M\R[obN */
#define SIO_ERDY_RCV	2u		/* MʒmR[obN */

/*
 *  SIOhCȍ[`
 */
extern void sh2scif_initialize (void);

/*
 *  I[vĂ|[g邩H
 */
extern BOOL sh2scif_openflag (ID siopid);

/*
 *  VAI/O|[g̃I[v
 */
extern SIOPCB *sh2scif_opn_por (ID siopid, VP_INT exinf);

/*
 *  VAI/O|[g̃N[Y
 */
extern void sh2scif_cls_por (SIOPCB * siopcb);

/*
 *  VAI/O|[gւ̕M
 */
extern BOOL sh2scif_snd_chr (SIOPCB * siopcb, char c);

/*
 *  VAI/O|[g̕M
 */
extern INT sh2scif_rcv_chr (SIOPCB * siopcb);

/*
 *  VAI/O|[g̃R[obN̋
 */
extern void sh2scif_ena_cbr (SIOPCB * siopcb, UINT cbrtn);

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
extern void sh2scif_dis_cbr (SIOPCB * siopcb, UINT cbrtn);

/*
 *  SIO̊݃T[rX[`
 */
extern void sh2scif_isr (void);

/*
 *  VAI/O|[g̑M\R[obN
 */
extern void sh2scif_ierdy_snd (VP_INT exinf);

/*
 *  VAI/O|[g̎MʒmR[obN
 */
extern void sh2scif_ierdy_rcv (VP_INT exinf);

#endif /* _SH2SCIF_H_ */
