/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: start.S,v 1.1 2008/06/17 00:04:54 suikan Exp $
 */

/*
 *	J[lp̃X^[gAbvW[iSH1pj
 */

#define	_MACRO_ONLY
#include <t_config.h>



/*
 *@@OxN^̒`iSH1pj
 *@@@ł̓ZbgɕKvȍŒ̃xN^pӂȂ
 *@@@cpu_initialize()ŗOxN^̈ړiVBȐjs
 */
#ifdef KERNEL_HAS_A_VECTOR_TABLE

/*
 *   ȉ̗OvŃftHgƂ͈قȂOxN^`
 *   ꍇ́Asys_config.hŊY}N`B
 */
	.section ".vector","ax"
	.align 2
	.long   TO_ASM(RESET_VECTOR)	/*   0:p[IZbg  */
	.long   INIT_STACK		/*       SP̏l        */
	.long   TO_ASM(RESET_VECTOR)	/*   2:}jAZbg  */
	.long   INIT_STACK		/*       SP̏l        */
	.long   TO_ASM(GII_VECTOR)	/*   4:ʕs        */
	.long   TO_ASM(RESERVED_VECTOR)	/*   5:VXe\        */
	.long   TO_ASM(SII_VECTOR)	/*   6:Xbgs    */
	.long   TO_ASM(RESERVED_VECTOR)	/*   7:VXe\        */
	.long   TO_ASM(RESERVED_VECTOR)	/*   8:VXe\        */
	.long   TO_ASM(CAE_VECTOR)	/*   9:CPUAhXG[   */
	.long   TO_ASM(DAE_VECTOR)	/*  10:DMAAhXG[   */
	.long   TO_ASM(NMI_VECTOR)	/*  11:MNI                 */
#endif /* KERNEL_HAS_A_VECTOR_TABLE */

/*
 *   SH1pX^[gAbvW[
 */
	.global	_start
	.section .text
	.align 2
_start:
	/*
	 *  SRBi݋֎~j
	 *  IPM=0xe
	 *  stubŝIPM=0xfƂȂB
	 */
	mov.l _init_sr,r0
	ldc   r0,sr
	/*
	 * ^XNReXg̃X^bNSTACKTOPɏ
	 * STACKTOṔAsys_config.hŒ`
	 */
	mov.l  _stack_k, r15

	/*
	 *  _hardware_init_hook ĂяoB(0łȂꍇ)
	 *
	 *  n[hEFAˑɕKvȏꍇ́C
	 *  hardware_init_hook Ƃ֐pӂ΂悢D
	 *  ̓IɂROM̍ہARAMgp\ɂ邽߂
	 *  oXRg[̏sB
	 *  sys_support.S  hardware_init_hook `Ă
	 *  D
	 */
start_0:
	/*
	 *  vZbTRAMpłꍇ͂̃AhX
	 *  INNER_RAM_ADDRESS}NƂsys_config.h܂
	 *  RpCEIvVŒ`B
	 *@iRAM̐擪AhXł͂ȂAX^bN̒
	 *@@_ɒӁj
	 *
	 *  ̏ꍇAhardware_init_hook()֐C
	 *  LqĂ悢B
	 *  ʂC̊֐Ăяo̓X^bNgp̂
	 *  oXRg[̏OɂłȂB
	 */
#ifdef INNER_RAM_ADDRESS
	mov.l  _inner_ram_address_k, r15
#endif /* INNER_RAM_ADDRESS */
	mov.l   _hardware_init_k, r0
	tst    r0,r0
	bt     start_1
	jsr    @r0
        nop


	/*
         * bssZNVNA
	 */
start_1:
	/*
         * X^bN|C^ORAMɍĐݒ肷BiLQƁj
	 */
#ifdef INNER_RAM_ADDRESS
	mov.l  _stack_k, r15
#endif /* INNER_RAM_ADDRESS */

	mov.l	_bss_start_k,r0
	mov.l	_end_k,r1
	cmp/eq  r0,r1
	bt      start_3
	mov	#0,r2
start_2:
	/*
	 *  r0̃CNg璷Ɍ邪
	 *  mov.l r4,@r0+߂͂Ȃ
	 *	fBXeBl[ṼAhX̓fBNĝ
	 */
        mov.l	r2,@r0
	add	#4,r0
 	cmp/hi	r0,r1
	bt	start_2

	/*
	 *  dataZNViROMΉjD
	 *
	 *  __idata_start  __idata_end ܂łC__data_start ȍ~
	 *  Rs[D
	 *
	 *@fobOɂĂdataZNV̔FɕsA
	 *@__idata_startԒnɃ_E[hׂf[^__data_start
	 *@ԒnɃ_E[hĂ܂̂B̏ꍇ
	 *@OMIT_DATA_SECTION_COPY}N`Ă邱Ƃł̃Rs[
	 *@ƂȗB
	 */
start_3:
#ifndef OMIT_DATA_SECTION_COPY	/*  dataZNṼRs[sꍇ  */
	mov.l   __idata_start_k,r1
	mov.l   __idata_end_k,r2
	cmp/eq  r1,r2
	bt      start_5
	mov.l   __data_start_k,r0
start_4:
	mov.l   @r1+,r4
	mov.l   r4,@r0
	cmp/hi  r1,r2
	add     #4,r0
	bt      start_4
#endif 	/* OMIT_DATA_SECTION_COPY */

	/*
	 *  software_init_hook Ăяoi0 łȂꍇjD
	 *
	 *  \tgEFAiɃCujɈˑĕKvȏ
	 *  ꍇ́Csoftware_init_hook Ƃ֐pӂ
	 *  悢D
	 */
start_5:
	mov.l  _software_init_hook_k, r0
	tst    r0,r0
	bt     start_6
	jsr    @r0
	nop


start_6:
	/*
         *  J[lN
	 */
	! call the mainline
	mov.l	_kernel_start_k,r0
	jsr	@r0
	nop


	.align 2
_intnest_k:
	.long	_intnest
_init_sr:
	.long	MAX_IPM << 4
_stack_k:
	.long   STACKTOP

#ifdef INNER_RAM_ADDRESS
_inner_ram_address_k:
	.long   INNER_RAM_ADDRESS
#endif /* INNER_RAM_ADDRESS */

_bss_start_k:
	.long   __bss_start

#ifdef FILL_STACK_WITH_0  /*  fobKŃX^bN̈ώ@Ղ  */
			  /*  邽߁A^XNReLXg    */
			  /*  X^bN̈            */
_end_k:
	.long   STACKTOP
#else			/*  X^bN̈Ȃꍇ  */
_end_k:			/*  @bssZNV  */
	.long  	_end
#endif	/* FILL_STACK_WITH_0  */


#ifndef OMIT_DATA_SECTION_COPY	/*  dataZNṼRs[sꍇ  */
__idata_start_k:
	.long 	__idata_start
__idata_end_k:
	.long   __idata_end
__data_start_k:
	.long  	__data_start
#endif 	/* OMIT_DATA_SECTION_COPY */

_kernel_start_k:
	.long	_kernel_start
_hardware_init_k:
	.long   _hardware_init_hook
_software_init_hook_k:
	.long   _software_init_hook

