/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: cpu_defs.h,v 1.1 2008/06/17 00:04:54 suikan Exp $
 */

/*
 *	vZbTɈˑ`iSH1pj
 *@@@@@AvP[VKvƂ`
 *
 *  ̃CN[ht@ĆCkernel.h  sil.h ŃCN[hD
 *  ̃t@C璼ڃCN[h邱Ƃ͂ȂD̃t@CC
 *  N[hOɁCt_stddef.h  itron.h CN[ĥŁC
 *  ɈˑĂ悢D
 */

#ifndef _CPU_DEFS_H_
#define _CPU_DEFS_H_

/*
 *  [U[`
 */
#include <user_config.h>	/*  SUPPORT_VXGET_TIM}N̒`  */


#define SH1			/* vZbT */
#define SH7032

/* J[lÑbZ[W   */
#define COPYRIGHT_CPU \
"Copyright (C) 2001-2004 by Industrial Technology Institute,\n" \
"                            Miyagi Prefectural Government, JAPAN\n"

#ifndef _MACRO_ONLY

/*
 *  ݁^CPUOnhԍ̌^
 */
typedef	UINT	INHNO;		/* ݃nhԍ */
typedef	UINT	EXCNO;		/* CPUOnhԍ */

/*
 *  ݃}XŇ^Ɗ݃}XN̕ύX^Q
 *  
 *  {#ifdef SUPPORT_CHG_IPM`#endifň͂ނׂA
 *  ̃t@Ccpu_config.hɃCN[h邽
 *  ȗĂB
 *  ̕c邱ƂɂAR[h͂قƂǂȂ̂
 *  Q͂ȂƔfB
 */
typedef	UINT	IPM;		/* ݃}XN */

extern ER	chg_ipm(IPM ipm) throw();
extern ER	get_ipm(IPM *p_ipm) throw();

/*
 *  SIL֘A̒`
 */


/*
 *  ݂̊݃}XN̓Ǐo
 */
#define _current_intmask_	current_intmask

/*
 *  ݃}XN̐ݒ
 */
#define _set_intmask_		set_intmask

/*
 *  NMIׂĂ݂̊֎~
 *  @disint()J[lǗ銄݂݂̂֎~̂ɑ΂
 *  @_disint_()̓J[lǗO݂̊܂߂ċ֎~B
 *  @̓IɂGDB stub̃VAM݂̈قȂB
 */
Inline void
_disint_(void)
{
	UW sr;

	Asm("stc  sr,%0" : "=r"(sr));
	sr |= 0x000000f0u;
	Asm("ldc %0, sr" : : "r"(sr) );
}


/*
 *  ݃bNԂ̐
 */
#define	SIL_PRE_LOC	UW _intmask_ = _current_intmask_()
#define	SIL_LOC_INT()	_disint_()
#define	SIL_UNL_INT()	_set_intmask_(_intmask_)


#endif /* _MACRO_ONLY */

/*
 *  vZbT̃GfBA
 */
#define	SIL_ENDIAN	SIL_ENDIAN_BIG	/* rbOGfBA */


#ifndef _MACRO_ONLY
/*
 *  \]pVXe̎Q
 */

#ifdef SUPPORT_VXGET_TIM
typedef	UD	SYSUTIM;	/* \]pVXe */

extern ER	vxget_tim(SYSUTIM *p_sysutim) throw();

#endif /*  SUPPORT_VXGET_TIM  */

#endif /* _MACRO_ONLY */


#endif /* _CPU_DEFS_H_ */
