/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *
 *  Copyright (C) 2004 by SEIKO EPSON Corp, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 *
 */

/*
 *  J[lp̃X^[gAbvW[(S1C33p)
 */

#include "jsp_kernel.h"
#include "sys_config.h"
#include "cpu_config.h"

/*
 *  O֐̎Q
 */
extern void init_lib(void);
extern void init_sys(void);

extern void INT_ENTRY(timer_handler)(void);
extern void INT_ENTRY(sio_in_handler)(void);
extern void INT_ENTRY(sio_out_handler)(void);

/*
 *  vg^Cv錾
 */
void start(void);
static void undef_handler(void);
static void hardware_init_hook(void);
static void software_init_hook(void);

/*
 *  xN^[e[u
 */
VP tps_VectorTable[] = {		/* offset   number */
	(VP) start,			/* 00  Reset			*/
	(VP) undef_handler,		/* 01  				*/
	(VP) undef_handler,		/* 02  				*/
	(VP) undef_handler,		/* 03                           */
	(VP) undef_handler,		/* 04  Zero division            */
	(VP) undef_handler,		/* 05                           */
	(VP) undef_handler,		/* 06  Address error exception  */
	(VP) undef_handler,		/* 07  debug                    */
	(VP) undef_handler,		/* 08  NMI                      */
	(VP) undef_handler,		/* 09                           */
	(VP) undef_handler,		/* 10                           */
	(VP) undef_handler,		/* 11                           */
	(VP) undef_handler,		/* 12  Software exception 0     */
	(VP) undef_handler,		/* 13  Software exception 1     */
	(VP) undef_handler,		/* 14  Software exception 2     */
	(VP) undef_handler,		/* 15  Software exception 3     */
	(VP) undef_handler,		/* 16 (00)                      */
	(VP) undef_handler,		/* 17 (01)                      */
	(VP) undef_handler,		/* 18 (02)                      */
	(VP) undef_handler,		/* 19 (03)                      */
	(VP) undef_handler,		/* 20 (04)                      */
	(VP) undef_handler,		/* 21 (05)                      */
	(VP) undef_handler,		/* 22 (06)                      */
	(VP) undef_handler,		/* 23 (07)                      */
	(VP) undef_handler,		/* 24 (08)                      */
	(VP) undef_handler,		/* 25 (09)                      */
	(VP) undef_handler,		/* 26 (10)                      */
	(VP) undef_handler,		/* 27 (11)                      */
	(VP) undef_handler,		/* 28 (12)                      */
	(VP) undef_handler,		/* 29 (13)                      */
	(VP) undef_handler,		/* 30 (14)                      */
	(VP) undef_handler,		/* 31 (15)                      */
	(VP) undef_handler,		/* 32 (16)                      */
	(VP) undef_handler,		/* 33 (17)                      */
	(VP) INT_ENTRY(timer_handler),	/* 34 (18) 16 bit programable timer 1-b */
	(VP) undef_handler,		/* 35 (19)                      */
	(VP) undef_handler,		/* 36 (20)                      */
	(VP) undef_handler,		/* 37 (21)                      */
	(VP) undef_handler,		/* 38 (22)                      */
	(VP) undef_handler,		/* 39 (23)                      */
	(VP) undef_handler,		/* 40 (24)                      */
	(VP) undef_handler,		/* 41 (25)                      */
	(VP) undef_handler,		/* 42 (26)                      */
	(VP) undef_handler,		/* 43 (27)                      */
	(VP) undef_handler,		/* 44 (28)                      */
	(VP) undef_handler,		/* 45 (29)                      */
	(VP) undef_handler,		/* 46 (30)                      */
	(VP) undef_handler,		/* 47 (31)                      */
	(VP) undef_handler,		/* 48 (32)                      */
	(VP) undef_handler,		/* 49 (33)                      */
	(VP) undef_handler,		/* 50 (34)                      */
	(VP) undef_handler,		/* 51 (35)                      */
	(VP) undef_handler,		/* 52 (36)                      */
	(VP) undef_handler,		/* 53 (37)                      */
	(VP) undef_handler,		/* 54 (38)                      */
	(VP) undef_handler,		/* 55 (39)                      */
	(VP) undef_handler,		/* 56 (40) Serial interface Ch.0 (error) */
	(VP) INT_ENTRY(sio_in_handler),	/* 57 (41) Serial interface Ch.0 (rx) */
	(VP) INT_ENTRY(sio_out_handler),/* 58 (42) Serial interface Ch.0 (tx) */
	(VP) undef_handler,		/* 59 (43)                      */
	(VP) undef_handler,		/* 60 (44)                      */
	(VP) undef_handler,		/* 61 (45)                      */
	(VP) undef_handler,		/* 62 (46)                      */
	(VP) undef_handler,		/* 63 (47)                      */
	(VP) undef_handler,		/* 64 (48)                      */
	(VP) undef_handler,		/* 65 (49)                      */
	(VP) undef_handler,		/* 66 (50)                      */
	(VP) undef_handler,		/* 67 (51)                      */
	(VP) undef_handler,		/* 68 (52)                      */
	(VP) undef_handler,		/* 69 (53)                      */
	(VP) undef_handler,		/* 70 (54)                      */
	(VP) undef_handler		/* 71 (55)                      */
};

/*
 *  u[g[`
 */
void start(void)
{
	/*
	 *  ftHgf[^GAAhXݒ肷
	 */
	Asm("xld.w %r15, __dp");

	/*
	 *  ^XNReXg̃X^bNSTACKTOPɏ
	 *  STACKTOṔAsys_config.hŒ`
	 */
	set_sp(STACKTOP);

	/*
	 * PSRA荞݂֎~
	 */
	set_psr(0x00000000);


	/*
	 *  hardware_init_hook ĂяoB(0łȂꍇ)
	 *
	 *  n[hEFAˑɕKvȏꍇ́C
	 *  hardware_init_hook Ƃ֐pӂ΂悢D
	 *  ̓IɂROM̍ہARAMgp\ɂ邽߂
	 *  oXRg[̏sB
	 *  sys_config.c  hardware_init_hook `ĂD
	 */
	if (hardware_init_hook != (VP) 0) {
		hardware_init_hook();
	}

	/*
	 *  dataZNViROMΉjD
	 */
	memcpy(VECTOR_START, IVECTOR_START, (UW)IVECTOR_END - (UW)IVECTOR_START);
	memcpy(DATA_START, IDATA_START, (UW)IDATA_END - (UW)IDATA_START);

	/*
	 *  bssZNV0NAB
	 */
	 memset(BSS_START, 0x00, BSS_END - BSS_START);

	/*
	 *  software_init_hook Ăяoi0 łȂꍇj
	 *
	 *  \tgEFAiɃCujɈˑĕKvȏ
	 *  ꍇ́Csoftware_init_hook Ƃ֐pӂ
	 *  悢D
	 */
	if (software_init_hook != (VP) 0) {
		software_init_hook();
	}

	/*
	 *  J[lN
	 */
	Asm("xjp kernel_start");

	do {
		Asm("halt");
	} while (TRUE);
}

/*
 *  _~[[`
 */
static void undef_handler(void)
{
	while(1){
		;
	}
}

/*
 *  VXeˑ̏
 */
static	void	hardware_init_hook(void)
{
	(*(s1c33Bcu_t *) S1C33_BCU_BASE).bTtbrProt = (IOREG)0x59;
	(*(s1c33Bcu_t *) S1C33_BCU_BASE).ulTtbr = (LIOREG)tps_VectorTable;

	(*(s1c33Bcu_t *) S1C33_BCU_BASE).uwBus = 0x0008;
	(*(s1c33Bcu_t *) S1C33_BCU_BASE).uwDram = 0x0c00;

	return;
}


/*
 *  \tgEFAˑ̏
 */
static	void	software_init_hook(void)
{
	init_lib();
	init_sys();
}
