/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: mpc860_sil.h,v 1.1 2008/06/17 00:04:45 suikan Exp $
 */

#include <sil.h>

/*
 *  MPC860̐䃌WX^ւ̃ANZXE[eBeB
 *  
 *  powerpc.hɋLq̂GKgAsil.hƂ̃CN[h
 *  Ԃ̊֌WœƗt@CƂB
 *  t_config.h𒼐ڃCN[hƂsil.hpowerpc.h
 *  CN[h\B
 *  
 *  RpČ^`FbN@\Lɂ邽߁A|C^^
 *  VB *AVH *AVW *pĂB
 *  
 */

#ifndef _MPC860_SIL_H_
#define _MPC860_SIL_H_

#ifndef _MACRO_ONLY

/*
 *  SILƓ̃ANZX֐i^`FbN@\tj
 */

#ifndef SIL_DEBUG

/*
 *  8rbgPʂ̓Ǐo^
 */
Inline VB
mpc860_reb_mem(VB *mem)
{
	VB reg = sil_reb_mem((VP)mem);
	return(reg);
}

Inline void
mpc860_wrb_mem(VB *mem, VB data)
{
	sil_wrb_mem((VP)mem, data);
}

/*
 *  16rbgPʂ̓Ǐo^
 */
Inline VH
mpc860_reh_mem(VH *mem)
{
	VH reg = sil_reh_mem((VP)mem);
	return(reg);
}

Inline void
mpc860_wrh_mem(VH *mem, VH data)
{
	sil_wrh_mem((VP)mem, data);
}

/*
 *  32rbgPʂ̓Ǐo^
 */
Inline VW
mpc860_rew_mem(VW *mem)
{
	VW reg = sil_rew_mem((VP)mem);
	return(reg);
}

Inline void
mpc860_wrw_mem(VW *mem, VW data)
{
	sil_wrw_mem((VP)mem, data);
}



/*
 *  rbgZ
 */

/*
 *  8rbgWX^ANDZ
 */
Inline void
mpc860_andb_mem(VB *mem, VB data)
{
	VB reg = mpc860_reb_mem((VP)mem);
	reg &= data;
	mpc860_wrb_mem(mem, reg);
}

/*
 *  8rbgWX^ORZ
 */
Inline void
mpc860_orb_mem(VB *mem, VB data)
{
	VB reg = mpc860_reb_mem(mem);
	reg |= data;
	mpc860_wrb_mem(mem, reg);
}


/*
 *  16rbgWX^ANDZ
 */
Inline void
mpc860_andh_mem(VH *mem, VH data)
{
	VH reg = mpc860_reh_mem(mem);
	reg &= data;
	mpc860_wrh_mem(mem, reg);
}

/*
 *  16rbgWX^ORZ
 */
Inline void
mpc860_orh_mem(VH *mem, VH data)
{
	VH reg = mpc860_reh_mem(mem);
	reg |= data;
	mpc860_wrh_mem(mem, reg);
}

/*
 *  32rbgWX^ANDZ
 */
Inline void
mpc860_andw_mem(VW *mem, VW data)
{
	VW reg = mpc860_rew_mem(mem);
	reg &= data;
	mpc860_wrw_mem(mem, reg);
}

/*
 *  32rbgWX^ORZ
 */
Inline void
mpc860_orw_mem(VW *mem, VW data)
{
	VW reg = mpc860_rew_mem(mem);
	reg |= data;
	mpc860_wrw_mem(mem, reg);
}

#else	/*  SIL_DEBUG  */

extern UW sil_log_id;
extern BOOL sil_debug_on;

/*
 *  SIL̃Oo͂蓖Ă郍Odvx̒`
 *@iuser.txt́u4.4 ȌdvxvQƁj
 */
#ifndef LOG_SIL
#define LOG_SIL	LOG_EMERG
#endif	/*  LOG_SIL  */


/*
 *  8rbgPʂ̓Ǐo
 */
#define mpc860_reb_mem(mem)	mpc860_reb_mem_deb(#mem, mem)

Inline VB
mpc860_reb_mem_deb(char *str, VB *mem)
{
	BOOL sil_debug_tmp, is_end_of_line;
	SYSUTIM sysutim;
	VB reg;
	ER err;
	SIL_PRE_LOC;
	
	sil_debug_tmp = sil_debug_on;
	if (sil_debug_on) {
		SIL_LOC_INT();
		sil_debug_on = FALSE;
		++sil_log_id;
		SIL_UNL_INT();
		err = vxget_tim(&sysutim);
		if (err != E_OK) {
			sysutim = 0;
		}
		SIL_LOC_INT();
	}
	
	reg = sil_reb_mem((VP)mem);

	if (sil_debug_tmp) {
		sil_debug_on = TRUE;
		SIL_UNL_INT();
		is_end_of_line = (reg == '\n') || (reg == '\r');
		if (!is_end_of_line) {
			syslog(LOG_SIL, 
			"%d time:%08d read VB %s(0x%08x) data=0x%02x(%c)",
			sil_log_id, (UW)sysutim, str, 
			(UW)mem, (UW)(UB)reg, (UW)(UB)reg);
		} else {
			syslog(LOG_SIL, 
			"%d time:%08d read VB %s(0x%08x) data=0x%02x(%s)",
			sil_log_id, (UW)sysutim, str, 
			(UW)mem, (UW)(UB)reg, 
			(reg == '\n') ? "\\n" : "\\r");
		}
	}
	
	return(reg);
}


/*
 *  8rbgPʂ̏
 */
#define mpc860_wrb_mem(mem, data)	mpc860_wrb_mem_deb(#mem, mem, data)

Inline void
mpc860_wrb_mem_deb(char *str, VB *mem, VB data)
{
	BOOL sil_debug_tmp, is_end_of_line;
	SYSUTIM sysutim;
	ER err;
	SIL_PRE_LOC;
	
	sil_debug_tmp = sil_debug_on;
	if (sil_debug_on) {
		SIL_LOC_INT();
		sil_debug_on = FALSE;
		++sil_log_id;
		SIL_UNL_INT();
		err = vxget_tim(&sysutim);
		if (err != E_OK) {
			sysutim = 0;
		}
		SIL_LOC_INT();
	}
	
	sil_wrb_mem((VP)mem, data);

	if (sil_debug_tmp) {
		sil_debug_on = TRUE;
		SIL_UNL_INT();
		is_end_of_line = (data == '\n') || (data == '\r');
		if (!is_end_of_line) {
			syslog(LOG_SIL, 
			"%d time:%08d write VB %s(0x%08x) data=0x%02x(%c)",
			sil_log_id, (UW)sysutim, str, 
			(UW)mem, (UW)(UB)data, (UW)(UB)data);
		} else {
			syslog(LOG_SIL, 
			"%d time:%08d write VB %s(0x%08x) data=0x%02x(%s)",
			sil_log_id, (UW)sysutim, str, 
			(UW)mem, (UW)(UB)data, 
			(data == '\n') ? "\\n" : "\\r");
		}
	}
}

/*
 *  16rbgPʂ̓Ǐo
 */
#define mpc860_reh_mem(mem)	mpc860_reh_mem_deb(#mem, mem)

Inline VH
mpc860_reh_mem_deb(char *str, VH *mem)
{
	BOOL sil_debug_tmp;
	SYSUTIM sysutim;
	VH reg;
	ER err;
	SIL_PRE_LOC;
	
	sil_debug_tmp = sil_debug_on;
	if (sil_debug_on) {
		SIL_LOC_INT();
		sil_debug_on = FALSE;
		++sil_log_id;
		SIL_UNL_INT();
		err = vxget_tim(&sysutim);
		if (err != E_OK) {
			sysutim = 0;
		}
		SIL_LOC_INT();
	}
	
	reg = sil_reh_mem((VP)mem);

	if (sil_debug_tmp) {
		sil_debug_on = TRUE;
		SIL_UNL_INT();
		syslog(LOG_SIL, 
			"%d time:%08d read VH %s(0x%08x) data=0x%04x",
			sil_log_id, (UW)sysutim, str, 
			(UW)mem, (UW)(UH)reg);
	}
	
	return(reg);
}

/*
 *  16rbgPʂ̏
 */
#define mpc860_wrh_mem(mem, data)	mpc860_wrh_mem_deb(#mem, mem, data)

Inline void
mpc860_wrh_mem_deb(char *str, VH *mem, VH data)
{
	BOOL sil_debug_tmp;
	SYSUTIM sysutim;
	ER err;
	SIL_PRE_LOC;
	
	sil_debug_tmp = sil_debug_on;
	if (sil_debug_on) {
		SIL_LOC_INT();
		sil_debug_on = FALSE;
		++sil_log_id;
		SIL_UNL_INT();
		err = vxget_tim(&sysutim);
		if (err != E_OK) {
			sysutim = 0;
		}
		SIL_LOC_INT();
	}
	
	sil_wrh_mem((VP)mem, data);

	if (sil_debug_tmp) {
		sil_debug_on = TRUE;
		SIL_UNL_INT();
		syslog(LOG_SIL, 
			"%d time:%08d write VH %s(0x%08x) data=0x%04x",
			sil_log_id, (UW)sysutim, str, 
			(UW)mem, (UW)(UH)data);
	}
}


/*
 *  32rbgPʂ̓Ǐo
 */
#define mpc860_rew_mem(mem)	mpc860_rew_mem_deb(#mem, mem)

Inline VW
mpc860_rew_mem_deb(char *str, VW *mem)
{
	BOOL sil_debug_tmp;
	SYSUTIM sysutim;
	VW reg;
	ER err;
	SIL_PRE_LOC;
	
	sil_debug_tmp = sil_debug_on;
	if (sil_debug_on) {
		SIL_LOC_INT();
		sil_debug_on = FALSE;
		++sil_log_id;
		SIL_UNL_INT();
		err = vxget_tim(&sysutim);
		if (err != E_OK) {
			sysutim = 0;
		}
		SIL_LOC_INT();
	}
	
	reg = sil_rew_mem((VP)mem);

	if (sil_debug_tmp) {
		sil_debug_on = TRUE;
		SIL_UNL_INT();
		syslog(LOG_SIL, 
			"%d time:%08d read VW %s(0x%08x) data=0x%08x",
			sil_log_id, (UW)sysutim, str, 
			(UW)mem, (UW)reg);
	}
	
	return(reg);
}


/*
 *  32rbgPʂ̏
 */
#define mpc860_wrw_mem(mem, data)	mpc860_wrw_mem_deb(#mem, mem, data)

Inline void
mpc860_wrw_mem_deb(char *str, VW *mem, VW data)
{
	BOOL sil_debug_tmp;
	SYSUTIM sysutim;
	ER err;
	SIL_PRE_LOC;
	
	sil_debug_tmp = sil_debug_on;
	if (sil_debug_on) {
		SIL_LOC_INT();
		sil_debug_on = FALSE;
		++sil_log_id;
		SIL_UNL_INT();
		err = vxget_tim(&sysutim);
		if (err != E_OK) {
			sysutim = 0;
		}
		SIL_LOC_INT();
	}
	
	sil_wrw_mem((VP)mem, data);

	if (sil_debug_tmp) {
		sil_debug_on = TRUE;
		SIL_UNL_INT();
		syslog(LOG_SIL, 
			"%d time:%08d write VW %s(0x%08x) data=0x%08x",
			sil_log_id, (UW)sysutim, str, 
			(UW)mem, (UW)data);
	}
}


/*
 *  rbgZ
 */

/*
 *  8rbgWX^ANDZ
 */
#define mpc860_andb_mem(mem, data)				\
	if (sil_debug_on) {					\
		syslog(LOG_SIL, "%s & 0x%02x",	 		\
			#mem, (UW)(UB)data);			\
	}							\
	mpc860_andb_mem_deb(mem, data)

Inline void
mpc860_andb_mem_deb(VB *mem, VB data)
{
	VB reg = mpc860_reb_mem((VP)mem);
	reg &= data;
	mpc860_wrb_mem(mem, reg);
}

/*
 *  8rbgWX^ORZ
 */
#define mpc860_orb_mem(mem, data)				\
	if (sil_debug_on) {					\
		syslog(LOG_SIL, "%s | 0x%02x",	 		\
			#mem, (UW)(UB)data);			\
	}							\
	mpc860_orb_mem_deb(mem, data)

Inline void
mpc860_orb_mem_deb(VB *mem, VB data)
{
	VB reg = mpc860_reb_mem(mem);
	reg |= data;
	mpc860_wrb_mem(mem, reg);
}


/*
 *  16rbgWX^ANDZ
 */
#define mpc860_andh_mem(mem, data)				\
	if (sil_debug_on) {					\
		syslog(LOG_SIL, "%s & 0x%04x",	 		\
			#mem, (UW)(UH)data);			\
	}							\
	mpc860_andh_mem_deb(mem, data)

Inline void
mpc860_andh_mem_deb(VH *mem, VH data)
{
	VH reg = mpc860_reh_mem(mem);
	reg &= data;
	mpc860_wrh_mem(mem, reg);
}

/*
 *  16rbgWX^ORZ
 */
#define mpc860_orh_mem(mem, data)				\
	if (sil_debug_on) {					\
		syslog(LOG_SIL, "%s | 0x%04x",	 		\
			#mem, (UW)(UH)data);			\
	}							\
	mpc860_orh_mem_deb(mem, data)

Inline void
mpc860_orh_mem_deb(VH *mem, VH data)
{
	VH reg = mpc860_reh_mem(mem);
	reg |= data;
	mpc860_wrh_mem(mem, reg);
}

/*
 *  32rbgWX^ANDZ
 */
#define mpc860_andw_mem(mem, data)				\
	if (sil_debug_on) {					\
		syslog(LOG_SIL, "%s & 0x%08x",	 		\
			#mem, (UW)data);			\
	}							\
	mpc860_andw_mem_deb(mem, data)

Inline void
mpc860_andw_mem_deb(VW *mem, VW data)
{
	VW reg = mpc860_rew_mem(mem);
	reg &= data;
	mpc860_wrw_mem(mem, reg);
}

/*
 *  32rbgWX^ORZ
 */
#define mpc860_orw_mem(mem, data)				\
	if (sil_debug_on) {					\
		syslog(LOG_SIL, "%s | 0x%08x",	 		\
			#mem, (UW)data);			\
	}							\
	mpc860_orw_mem_deb(mem, data)

Inline void
mpc860_orw_mem_deb(VW *mem, VW data)
{
	VW reg = mpc860_rew_mem(mem);
	reg |= data;
	mpc860_wrw_mem(mem, reg);
}


#endif	/*  SIL_DEBUG  */

/*
 *  CPR}hs\ɂȂ܂ő҂
 */
Inline void
mpc860_wait_ready_CP_command(void)
{
	UH cpcr;
    	do {
		cpcr = mpc860_reh_mem(CPCR);
    	} while(cpcr & CPCR_FLG); 
}	


/*
 *  CPR}h𔭍s
 *	
 *	@UW opcodeFR}h
 *	@UW ch_numF`lԍifoCXԍj
 */
Inline void
mpc860_CP_command(UW opcode, UW ch_num)
{
	UH cpcr;
	
	/*  CPR}hI҂  */
	mpc860_wait_ready_CP_command();
	
	/*  CPR}hs  */
	cpcr = (UH)((opcode << 8) | (ch_num << 4) | CPCR_FLG);
    	mpc860_wrh_mem(CPCR, cpcr);

	/*  CPR}hI҂  */
	mpc860_wait_ready_CP_command();
    	
}



#endif /* _MACRO_ONLY */
#endif	/*  _MPC860_SIL_H_  */
/*  end of file  */
