/* 
 *
 *  TOPPERS/JSP Kernel
 *     Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2004 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN  
 * 
 * L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 * ɂČ\Ă GNU General Public License  Version 2 ɋL
 * qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 * ς̂܂ށDȉjgpEEρEĔzziȉC
 * pƌĂԁj邱Ƃ𖳏ŋD
 * (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *     \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *     XR[hɊ܂܂Ă邱ƁD
 * (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *     pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *     ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *     ̖ۏ؋Kfڂ邱ƁD
 * (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *     płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *     ƁD
 *   (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *       쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *   (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *       񍐂邱ƁD
 * (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *     QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 * {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 * TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 * ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 * ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 *
 *  @(#) $Id: cpu_support.S,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */

#define _MACRO_ONLY

/*
 *  AvP[VƋʂ̃CN[ht@C
 */
#include <kernel.h>
/*
 *  ^[Qbgˑ̒`
 */
#include <t_config.h>

#include "jsp_kernel.h"
#include "offset.h"
#include <nios2.h>

    .set noat
    .section .exceptions, "xa"
    .align 2
    .global _irq_entry
    .type   _irq_entry, @function
_irq_entry:
    /*
     *  Ov̔
     */
    rdctl   et, estatus
    andi    et, et, 1
    beq     et, zero, _check_trap
    rdctl   et, ipending
    beq     et, zero, _check_trap

    
   /*
    * Ov͊
    */
    addi ea, ea, -4      /* ߂ԒnfNg */

    addi  sp, sp, -76    /* WX^̕ۑ */
    rdctl et, estatus
    stw   et,   0(sp)
    stw   at,   4(sp)
    stw   r2,   8(sp)
    stw   r3,  12(sp)
    stw   r4,  16(sp)
    stw   r5,  20(sp)
    stw   r6,  24(sp)
    stw   r7,  28(sp)
    stw   r8,  32(sp)
    stw   r9,  36(sp)
    stw   r10, 40(sp)
    stw   r11, 44(sp)
    stw   r12, 48(sp)
    stw   r13, 52(sp)
    stw   r14, 56(sp)
    stw   r15, 60(sp)
    stw   fp,  64(sp)
    stw   ra,  68(sp)
    stw   ea,  72(sp)

    /*
     * d݂
     */
    ldw   r3, %gprel(interrupt_count)(gp)  /* lXg񐔂̃`FbN */
    bltu  zero, r3,  nest_int

    movhi r2, %hiadj(STACKTOP-4)
    addi  r2, r2, %lo(STACKTOP-4)
    stw   sp, 0(r2)     /* X^bN|C^̕ۑ */        
    mov   sp, r2        /* X^bN|C^̓ւ */
nest_int:
    /*
     *  ݗv̔ƌĂяo
     */
    call int_handler_call

ret_from_int:
    ldw   r3, %gprel(interrupt_count)(gp)   
    bltu  zero, r3, res_reg_and_ret /* lXg񐔂1ȏȂ߂ */

    ldw   r2, 0(sp)                 /* X^bN|C^߂ */
    mov   sp, r2                    /* X^bN|C^߂ */

    ldw   r3, %gprel(reqflg)(gp)    /* reqflg̃`FbN */
    beq   r3, zero, res_reg_and_ret
    br    ret_int

res_reg_and_ret:
    ldw   et,   0(sp)  /* WX^̕A */
    wrctl estatus, et
    ldw   at,   4(sp)
    ldw   r2,   8(sp)
    ldw   r3,  12(sp)
    ldw   r4,  16(sp)
    ldw   r5,  20(sp)
    ldw   r6,  24(sp)
    ldw   r7,  28(sp)
    ldw   r8,  32(sp)
    ldw   r9,  36(sp)
    ldw   r10, 40(sp)
    ldw   r11, 44(sp)
    ldw   r12, 48(sp)
    ldw   r13, 52(sp)
    ldw   r14, 56(sp)
    ldw   r15, 60(sp)
    ldw   fp,  64(sp)
    ldw   ra,  68(sp)
    ldw   ea,  72(sp)
    addi  sp, sp, 76        
    eret      


_check_trap:        
    /*
     *  Trap
     */
    ldw   et, -4(ea)               /* Oo߂擾 */
    xorhi et, et, 0x003b           /*  16bit             */
    xori  et, et, 0x683a           /*  16bit             */
    beq   et, zero, trap_handler

_check_exc:
    addi  sp, sp, -76
    rdctl et,   estatus
    stw   et,    0(sp)
    stw   at,    4(sp)
    stw   r2,    8(sp)
    stw   r3,   12(sp)
    stw   r4,   16(sp)
    stw   r5,   20(sp)
    stw   r6,   24(sp)
    stw   r7,   28(sp)
    stw   r8,   32(sp)
    stw   r9,   36(sp)
    stw   r10,  40(sp)
    stw   r11,  44(sp)
    stw   r12,  48(sp)
    stw   r13,  52(sp)
    stw   r14,  56(sp)
    stw   r15,  60(sp)
    stw   fp,   64(sp)
    stw   ra,   68(sp)
    stw   ea,   72(sp)
    mov   r4,   sp     /* nḧ */

    /*
     * d݂
     */
    ldw   r3, %gprel(interrupt_count)(gp)  /* lXg񐔂̃`FbN */
    bltu  zero, r3,  nest_int_exc
    
    movhi r2, %hiadj(STACKTOP-4)
    addi  r2, r2, %lo(STACKTOP-4)
    stw   sp, 0(r2)     /* X^bN|C^̕ۑ */        
    mov   sp, r2        /* X^bN|C^̓ւ */
nest_int_exc:
    
    call exc_handler_call  /* CPUOnhĂяo[`̎s */

    br ret_from_int        /* ^[ */


trap_handler:
   /*
    *  Trapnh[
    */
    eret  



    .set noat
    .align  2
    .global ret_int
    .global ret_exc
ret_int:
ret_exc:
    stw   zero, %gprel(reqflg)(gp)   /* reqflg  FALSE */
    ldw   r5,   %gprel(runtsk)(gp)   /* r5 <- runtsk      */
    ldw   r6,   %gprel(enadsp)(gp)   /* r6 <- enadsp      */
    beq   r6,   zero, ret_int_1      /* enadsp  FALSE Ȃ ret_int_1  */
    ldw   r4,   %gprel(schedtsk)(gp) /* r4 <- schedtsk    */
    beq   r4,   r5, ret_int_1        /* runtsk  schedtskȂret_int_1 */
    addi  sp,   sp, -32              /* c̃WX^ۑ */    
    stw   r16,  0(sp)
    stw   r17,  4(sp)
    stw   r18,  8(sp)
    stw   r19, 12(sp)
    stw   r20, 16(sp)
    stw   r21, 20(sp)
    stw   r22, 24(sp)
    stw   r23, 28(sp)
    stw   sp,  TCB_sp(r5)         /* ^XNX^bNTCBɕۑ */
    movhi r2,  %hiadj(ret_int_r)  /* sJnԒnۑ        */
    addi  r2,  r2, %lo(ret_int_r)
    stw   r2,  TCB_pc(r5)         /* sĊJԒnTCBɕۑ   */
    br    dispatcher

ret_int_r:
    ldw   r16,  0(sp)       /* WX^𕜋A */
    ldw   r17,  4(sp)
    ldw   r18,  8(sp)
    ldw   r19, 12(sp)
    ldw   r20, 16(sp)
    ldw   r21, 20(sp)
    ldw   r22, 24(sp)
    ldw   r23, 28(sp)
    addi  sp, sp, 32    
ret_int_1:
    /*
     *  ^XNO[`̋N    
     *  ret_int_r  dispatcher Ăяo邽߁C
     *  tcb̃AhX r4 ɓĂ
     */
    ldw  r5, TCB_enatex(r4)       /* r5 <- enatex */
#if TCB_enatex_mask > 0xffff
    andhi r6, r5, %hi(TCB_enatex_mask)
#else
    andi r6, r5, %lo(TCB_enatex_mask)
#endif /* TCB_enatex_mask > 0xffff */
    andhi r6, r5, 4
    beq  r6, zero, ret_int_2      /* enatex  FALSE Ȃ烊^[ */
    ldw  r7, TCB_texptn(r4)       /* r7 <- texptn, texptn0łȂ */
    beq  zero, r7, ret_int_2      
    call call_texrtn              /* ^XNO[`̌Ăяo */

ret_int_2:
    ldw   et,   0(sp)    /* WX^𕜋A */
    wrctl estatus, et
    ldw   at,   4(sp)
    ldw   r2,   8(sp)
    ldw   r3,  12(sp)
    ldw   r4,  16(sp)
    ldw   r5,  20(sp)
    ldw   r6,  24(sp)
    ldw   r7,  28(sp)
    ldw   r8,  32(sp)
    ldw   r9,  36(sp)
    ldw   r10, 40(sp)
    ldw   r11, 44(sp)
    ldw   r12, 48(sp)
    ldw   r13, 52(sp)
    ldw   r14, 56(sp)
    ldw   r15, 60(sp)
    ldw   fp,  64(sp)
    ldw   ra,  68(sp)
    ldw   ea,  72(sp)
    addi  sp, sp, 76        
    eret      


    

    .global dispatch
    .align  2
dispatch:
    addi  sp, sp, -40                /* WX^ۑ */    
    stw   r16,  0(sp)
    stw   r17,  4(sp)
    stw   r18,  8(sp)
    stw   r19, 12(sp)
    stw   r20, 16(sp)
    stw   r21, 20(sp)
    stw   r22, 24(sp)
    stw   r23, 28(sp)
    stw   fp,  32(sp)
    stw   ra,  36(sp)
    ldw   r4,  %gprel(runtsk)(gp)  /* r4 <- runtsk              */
    stw   sp,  TCB_sp(r4)          /* ^XNX^bNTCBɕۑ */
    movhi r5,  %hiadj(dispatch_r)  /* sJnԒnۑ        */
    addi  r5,  r5, %lo(dispatch_r)
    stw   r5,  TCB_pc(r4)          /* sĊJԒnTCBɕۑ   */
    br    dispatcher

dispatch_r:
    ldw   r16,  0(sp)              /* WX^𕜋A */
    ldw   r17,  4(sp)
    ldw   r18,  8(sp)
    ldw   r19, 12(sp)
    ldw   r20, 16(sp)
    ldw   r21, 20(sp)
    ldw   r22, 24(sp)
    ldw   r23, 28(sp)
    ldw   fp,  32(sp)     
    /*
     * ^XNO[`̋N
     *  dispatch_r  dispatcher Ăяo邽߁C
     *  tcb ̃AhX r4 ɓĂ
     */    
    ldw  r5, TCB_enatex(r4)       /* r5 <- enatex */
#if TCB_enatex_mask > 0xffff
    andhi r6, r5, %hi(TCB_enatex_mask)
#else
    andi r6, r5, %lo(TCB_enatex_mask)
#endif /* TCB_enatex_mask > 0xffff */
    beq  r6, zero, dispatch_r_1   /* enatex  FALSE Ȃ烊^[ */
    ldw  r7, TCB_texptn(r4)       /* r7 <- texptn, texptn0łȂ */
    beq  r7, zero, dispatch_r_1    
    call call_texrtn              /* ^XNO[`̌Ăяo */

dispatch_r_1:
    ldw   ra, 36(sp)              /* c̃WX^𕜋A */    
    addi  sp, sp, 40                
    ret



    .global exit_and_dispatch
exit_and_dispatch:
    stw      zero, %gprel(interrupt_count)(gp)  /* interrupt_count NA */
dispatcher:
    /*
     * ͊݋֎~ŗ邱
     */    
    ldw   r4,   %gprel(schedtsk)(gp) /* r4 <- schedtsk              */
    stw   r4,   %gprel(runtsk)(gp)   /* schedtsk  runtsk        */
    beq   r4,   zero, dispatcher_1   /* schedtsk邩            */
    ldw   sp,   TCB_sp(r4)           /* TCB^XNX^bN𕜋A */
    ldw   r5,   TCB_pc(r4)           /* TCBsĊJԒn𕜋A   */
    jmp   r5
dispatcher_1:
    /*
     * Ŋ݃[hɐ؂ւ̂́CŔ銄ݏ
     * ɂǂ̃X^bNgƂ̉ƁC݃nh
     * ̃^XNfBXpb`̖h~Ƃ2̈ӖD
     */
    movhi sp, %hiadj(STACKTOP)            /* ݃X^bNɕύX  */
    addi  sp, sp, %lo(STACKTOP)              
    movi  r5, 1                           /* interrupt_count 1 */
    stw   r5, %gprel(interrupt_count)(gp)  
dispatcher_2:
    wrctl status, r5      /* ݂̋ */
    nop
    nop
    nop
    nop
    wrctl status, zero                      /* ݂̋֎~             */
    ldw   r6, %gprel(reqflg)(gp)            /* r6 <- reqflg             */
    beq   r6, zero, dispatcher_2            /* reqflg  FALSE Ȃ     */
    stw   zero, %gprel(interrupt_count)(gp) /* interrupt_count NA */ 
    stw   zero, %gprel(reqflg)(gp)          /* reqflg  FALSE        */ 
    br    dispatcher


    .text
    .global activate_r
    .align 2
activate_r:
    movi  r2, 1
    wrctl status, r2      /* ݋       */
    ldw   r4, 4(sp)       /* (exinf)      */
    ldw   r2, 0(sp)       /* ^XN̎sԒn */
    addi  sp, sp, 8
    movhi ra, %hiadj(ext_tsk)
    addi  ra, ra, %lo(ext_tsk)
    jmp   r2              /* ^XN̎sJn */


