/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2007 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: m32relf.ld,v 1.1 2008/06/17 00:04:43 suikan Exp $
 */

OUTPUT_FORMAT("elf32-m32r","elf32-m32r","elf32-m32r")
OUTPUT_ARCH(m32r)

PROVIDE(__stack = 0x00f10000);
PROVIDE(hardware_init_hook = 0);
PROVIDE(software_init_hook = 0);
PROVIDE(software_term_hook = 0);
PROVIDE(_kernel__unhandled_interrupt_handler = 0);

MEMORY
{
	ROM(raxi) : org = 0x00f00000, len = 64k	/* RAM */
	RAM(waxi) : org = 0x01000000, len = 16M /* OSDRAM */
}

SECTIONS
{
	/* ݃xN^ړꍇ͎̃RgƂāA
	   .text̐擪ɂ*(.vector)RgAEg΂悢 */
/*
	.vector : 
	{	*(.vector)		} > ROM
*/

	. = ALIGN(4);
    .text :	
    {
        *(.vector)

        __stext = . ;
        *(.text)
		__etext = . ;
    } > ROM

	. = ALIGN(4);
    .rodata : 
	{
		__srodata = .;
		 *(.rodata)
		__erodata = .;
	} > ROM

	. = ALIGN(4);
	__sidata = . ;

    .data   :  AT(__sidata) 
    {
		. = ALIGN(4);
		__sdata = .;
        *(.data)
		. = ALIGN(4);
		__edata = .;
    } > RAM

	__eidata = __edata - __sdata + __sidata;

    .bss :
    {
		. = ALIGN(4);
		__sbss = .;
		*(.bss)
		*(COMMON)
		. = ALIGN(4);
		__ebss = .;
    } > RAM

    .comment 0 : { *(.comment) }	
    .debug          0 : { *(.debug) }
    .line           0 : { *(.line) }
    .debug_srcinfo  0 : { *(.debug_srcinfo) }
    .debug_sfnames  0 : { *(.debug_sfnames) }
    .debug_aranges  0 : { *(.debug_aranges) }
    .debug_pubnames 0 : { *(.debug_pubnames) }	
}
