/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2003-2004 by Naoki Saito
 *             Nagoya Municipal Industrial Research Institute, JAPAN
 *  Copyright (C) 2003-2004 by Platform Development Center
 *                                          RICOH COMPANY,LTD. JAPAN
 * 
 *  L쌠҂́CFree Software Foundation ɂČ\Ă 
 *  GNU General Public License  Version 2 ɋLqĂC
 *  (1)`(4)̏𖞂ꍇɌC{\tgEFAi{\tgEF
 *  Aς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFAėp\ȃoCiR[hiP[^uIu
 *      WFNgt@C⃉CuȂǁǰ`ŗpꍇɂ́Cp
 *      ɔhLgip҃}jAȂǁjɁCL̒쌠\C
 *      ̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAėps\ȃoCiR[ȟ`܂͋@ɑg
 *      ݍ񂾌`ŗpꍇɂ́Ĉꂩ̏𖞂ƁD
 *    (a) pɔhLgip҃}jAȂǁjɁCL̒
 *        \C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) p̌`ԂCʂɒ߂@ɂāCL쌠҂ɕ񍐂
 *        ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂́C
 *  {\tgEFAɊւāC̓Kp\܂߂āCȂۏ؂s
 *  ȂD܂C{\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ
 *  Ȃ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: oaks32.h,v 1.1 2008/06/17 00:04:45 suikan Exp $
 */

#ifndef _OAKS32_H_
#define	_OAKS32_H_

/*
 *  ݔԍ̒`
 */
#define	INT_BRK		0		/* BRK */
#define INT_AD1		7		/* `-cϊ1 */
#define INT_DMA0	8		/* DMA0 */
#define INT_DMA1	9		/* DMA1 */
#define INT_DMA2	10		/* DMA2 */
#define INT_DMA3	11		/* DMA3 */
#define INT_TA0		12		/* ^C}A0 */
#define INT_TA1		13		/* ^C}A1 */
#define INT_TA2		14		/* ^C}A2 */
#define INT_TA3		15		/* ^C}A3 */
#define INT_TA4		16		/* ^C}A4 */
#define INT_S0TNACK	17		/* UART0M,NACK */
#define INT_S0RACK	18		/* UART0M,ACK */
#define INT_S1TNACK	19		/* UART1M,NACK */
#define INT_S1RACK	20		/* UART1M,ACK */
#define INT_TB0		21		/* ^C}B0 */
#define INT_TB1		22		/* ^C}B1 */
#define INT_TB2		23		/* ^C}B2 */
#define INT_TB3		24		/* ^C}B3 */
#define INT_TB4		25		/* ^C}B4 */
#define INT_INT5	26		/* INT5 */
#define INT_INT4	27		/* INT4 */
#define INT_INT3	28		/* INT3 */
#define INT_INT2	29		/* INT2 */
#define INT_INT1	30		/* INT1 */
#define INT_INT0	31		/* INT0 */
#define INT_TB5		32		/* ^C}B5 */
#define INT_S2TNACK 	33		/* UART2M,NACK */
#define INT_S2RACK 	34		/* UART2M,ACK */
#define INT_S3TNACK 	35		/* UART3M,NACK */
#define INT_S3RACK 	36		/* UART3M,ACK */
#define INT_S4TNACK 	37		/* UART4M,NACK */
#define INT_S4RACK 	38		/* UART4M,ACK */

#define INT_AD0		42		/* `-cϊ0 */
#define INT_KEY		43		/* L[͊荞 */
#define INT_IIO0	44		/* CeWFgI/O0 */
#define INT_IIO1	45		/* CeWFgI/O1 */
#define INT_IIO2	46		/* CeWFgI/O2 */
#define INT_IIO3	47		/* CeWFgI/O3 */
#define INT_IIO4	48		/* CeWFgI/O4 */
#define INT_IIO5	49		/* CeWFgI/O5 */
#define INT_IIO6	50		/* CeWFgI/O6 */
#define INT_IIO7	51		/* CeWFgI/O7 */
#define INT_IIO8	52		/* CeWFgI/O8 */
#define INT_IIO9CAN0	53		/* CeWFgI/O9,CAN0 */
#define INT_IIO10CAN1	54		/* CeWFgI/O10,CAN1 */
#define INT_IIO11CAN2	57		/* CeWFgI/O11,CAN2 */

/*
 *  OAKS32 SFRAhX`
 *
 *  ݃WX^
 */
#define	TADR_SFR_INT_BASE       0x60			/* ݊֘Ãx[XAhX */
#define TADR_SFR_DM0IC_OFFSET  8				/* DMA0ݐ䃌WX^ */
#define TADR_SFR_TB5IC_OFFSET   9				/* timerB5 ݐ䃌WX^ */
#define TADR_SFR_DMA2IC_OFFSET  10				/* DMA2ݐ䃌WX^ */
#define	TADR_SFR_S2RIC_OFFSET   11				/* uart2Mݐ䃌WX^ */
#define	TADR_SFR_TA0IC_OFFSET   12				/* timerA0 ݐ䃌WX^ */
#define	TADR_SFR_S3RIC_OFFSET   13				/* uart3Mݐ䃌WX^ */
#define TADR_SFR_TA2IC_OFFSET   14				/* timerA2 ݐ䃌WX^ */
#define	TADR_SFR_S4RIC_OFFSET   15				/* uart4Mݐ䃌WX^ */
#define TADR_SFR_TA4IC_OFFSET   16				/* timerA4 ݐ䃌WX^ */
#define TADR_SFR_BCN0IC_OFFSET  17				/* UART0oXՓˌoݐ䃌WX^ */
#define TADR_SFR_BCN3IC_OFFSET  17				/* UART3oXՓˌoݐ䃌WX^ */
#define	TADR_SFR_S0RIC_OFFSET   18				/* uart0Mݐ䃌WX^ */
#define TADR_SFR_AD0IC_OFFSET   19				/* A-D0ϊݐ䃌WX^ */
#define	TADR_SFR_S1RIC_OFFSET   20				/* uart1Mݐ䃌WX^ */
#define TADR_SFR_IIO0IC_OFFSET  21				/* CeWFgI/Oݐ䃌WX^0 */
#define TADR_SFR_TB1IC_OFFSET   22				/* timerB1 ݐ䃌WX^ */
#define TADR_SFR_IIO2IC_OFFSET  23				/* CeWFgI/Oݐ䃌WX^2 */
#define TADR_SFR_TB3IC_OFFSET   24				/* timerB3 ݐ䃌WX^ */
#define TADR_SFR_IIO4IC_OFFSET  25				/* CeWFgI/Oݐ䃌WX^4 */
#define TADR_SFR_INT5IC_OFFSET  26				/* SI/O4/INT5 ݐ䃌WX^ */
#define TADR_SFR_IIO6IC_OFFSET  27				/* CeWFgI/Oݐ䃌WX^6 */
#define TADR_SFR_INT3IC_OFFSET  28				/* INT3 ݐ䃌WX^ */
#define TADR_SFR_IIO8IC_OFFSET  29				/* CeWFgI/Oݐ䃌WX^8 */
#define TADR_SFR_INT1IC_OFFSET  30				/* INT1 ݐ䃌WX^ */
#define TADR_SFR_IIO10IC_OFFSET 31				/* CeWFgI/Oݐ䃌WX^10 */
#define TADR_SFR_CAN1IC_OFFSET  31				/* CAN1䃌WX^ */
#define TADR_SFR_IIO11IC_OFFSET 33				/* CeWFgI/Oݐ䃌WX^11 */
#define TADR_SFR_CAN2IC_OFFSET  33				/* CAN2䃌WX^ */
#define TADR_SFR_AD1IC_OFFSET   38				/* A-D1ϊݐ䃌WX^ */
#define TADR_SFR_DM1IC_OFFSET   40				/* DMA1ݐ䃌WX^ */
#define	TADR_SFR_S2TIC_OFFSET   41				/* uart2Mݐ䃌WX^ */
#define TADR_SFR_DM3IC_OFFSET   42				/* DMA3ݐ䃌WX^ */
#define	TADR_SFR_S3TIC_OFFSET   43				/* uart3Mݐ䃌WX^ */
#define TADR_SFR_TA1IC_OFFSET   44				/* timerA1 ݐ䃌WX^ */
#define	TADR_SFR_S4TIC_OFFSET   45				/* uart4Mݐ䃌WX^ */
#define TADR_SFR_TA3IC_OFFSET   46				/* timerA3 ݐ䃌WX^ */
#define TADR_SFR_BCN2IC_OFFSET  47				/* UART2oXՓˌoݐ䃌WX^ */
#define	TADR_SFR_S0TIC_OFFSET   48				/* uart0Mݐ䃌WX^ */
#define TADR_SFR_BCN1IC_OFFSET  49				/* UART1oXՓˌoݐ䃌WX^ */
#define TADR_SFR_BCN4IC_OFFSET  49				/* UART4oXՓˌoݐ䃌WX^ */
#define	TADR_SFR_S1TIC_OFFSET   50				/* uart1Mݐ䃌WX^ */
#define TADR_SFR_KUPIC_OFFSET   51				/* L[͊ݐ䃌WX^ */
#define TADR_SFR_TB0IC_OFFSET   52				/* timerB0 ݐ䃌WX^ */
#define TADR_SFR_IIO1IC_OFFSET  53				/* CeWFgI/Oݐ䃌WX^1 */
#define TADR_SFR_TB2IC_OFFSET   54				/* timerB2 ݐ䃌WX^ */
#define TADR_SFR_IIO3IC_OFFSET  55				/* CeWFgI/Oݐ䃌WX^3 */
#define TADR_SFR_TB4IC_OFFSET   56				/* timerB4 ݐ䃌WX^ */
#define TADR_SFR_IIO5IC_OFFSET  57				/* CeWFgI/Oݐ䃌WX^5 */
#define TADR_SFR_INT4IC_OFFSET  58				/* INT4 ݐ䃌WX^ */
#define TADR_SFR_IIO7IC_OFFSET  59				/* CeWFgI/Oݐ䃌WX^7 */
#define TADR_SFR_INT2IC_OFFSET  60				/* INT2 ݐ䃌WX^ */
#define TADR_SFR_IIO9IC_OFFSET  61				/* CeWFgI/Oݐ䃌WX^9 */
#define TADR_SFR_CAN0IC_OFFSET  61				/* CAN0䃌WX^ */
#define TADR_SFR_INT0IC_OFFSET  62				/* INT0 ݐ䃌WX^ */

/*
 *  ^C}[WX^
 */
#define TADR_SFR_TBSR           0x300			/* timerB3,4,5JEgJntO */
#define TADR_SFR_TA11           0x302			/* timerA1-1WX^ */
#define TADR_SFR_TA21           0x304			/* timerA2-1WX^ */
#define TADR_SFR_TA41           0x306			/* timerA4-1WX^ */
#define TADR_SFR_INVC0          0x308			/* OPWM䃌WX^O */
#define TADR_SFR_INVC1          0x309			/* OPWM䃌WX^P */
#define TADR_SFR_IDB0           0x30a			/* Oo̓obt@WX^O */
#define TADR_SFR_IDB1           0x30b			/* Oo̓obt@WX^P */
#define TADR_SFR_DTT            0x30c			/* Zh~^C} */
#define TADR_SFR_ICTB2          0x30d			/* timerB2ݔpxݒJE^ */
#define TADR_SFR_TB3            0x310			/* timerB3WX^ */
#define TADR_SFR_TB4            0x312			/* timerB4WX^ */
#define TADR_SFR_TB5            0x314			/* timerB5WX^ */
#define	TADR_SFR_TB3MR          0x31b			/* timerB3[hWX^ */
#define	TADR_SFR_TB4MR          0x31c			/* timerB4[hWX^ */
#define	TADR_SFR_TB5MR          0x31d			/* timerB5[hWX^ */
#define TADR_SFR_IFSR           0x31f			/* ݗvIWX^ */

#define	TADR_SFR_TABSR          0x340			/* JEgJntO */
#define TADR_SFR_CPSRF          0x341			/* Zbg vXP[ ZbgtO */
#define TADR_SFR_ONSF           0x342			/* Vg X^[gtO */
#define TADR_SFR_TRGSR          0x343			/* gK[ZNg WX^ */
#define	TADR_SFR_UDF            0x344			/* Abv_EtO */
#define	TADR_SFR_TA0            0x346			/* timerA0WX^ */
#define TADR_SFR_TA1            0x348			/* timerA1WX^ */
#define TADR_SFR_TA2            0x34a			/* timerA2WX^ */
#define TADR_SFR_TA3            0x34c			/* timerA3WX^ */
#define TADR_SFR_TA4            0x34e			/* timerA4WX^ */
#define TADR_SFR_TB0            0x350			/* timerB0WX^ */
#define TADR_SFR_TB1            0x352			/* timerB1WX^ */
#define TADR_SFR_TB2            0x354			/* timerB2WX^ */
#define	TADR_SFR_TA0MR          0x356			/* timerA0[hWX^ */
#define	TADR_SFR_TA1MR          0x357			/* timerA1[hWX^ */
#define	TADR_SFR_TA2MR          0x358			/* timerA2[hWX^ */
#define	TADR_SFR_TA3MR          0x359			/* timerA3[hWX^ */
#define	TADR_SFR_TA4MR          0x35a			/* timerA4[hWX^ */
#define	TADR_SFR_TB0MR          0x35b			/* timerB0[hWX^ */
#define	TADR_SFR_TB1MR		0x35c			/* timerB1[hWX^ */
#define	TADR_SFR_TB2MR          0x35d			/* timerB2[hWX^ */
#define	TADR_SFR_TB2SC          0x35e			/* timerB2XyV[hWX^ */
#define TADR_SFR_TCSPR          0x35f			/* JEg\[XvXP[WX^ */

/*
 *  VAWX^
 */
#define	TADR_SFR_UART0_BASE     0x360			/* uart0WX^x[XAhX */
#define	TADR_SFR_UART1_BASE     0x2e0			/* uart1WX^x[XAhX */
#define	TADR_SFR_UART2_BASE     0x330			/* uart2WX^x[XAhX */
#define	TADR_SFR_UART3_BASE     0x320			/* uart3WX^x[XAhX */
#define	TADR_SFR_UART4_BASE     0x2f0			/* uart4WX^x[XAhX */

#define	TADR_SFR_USMR_OFFSET    7			/* ꃂ[hWX^ */
#define	TADR_SFR_USMR2_OFFSET   6			/* ꃂ[hWX^2 */
#define	TADR_SFR_USMR3_OFFSET   5			/* ꃂ[hWX^3 */
#define	TADR_SFR_USMR4_OFFSET   4			/* ꃂ[hWX^4 */

#define	TADR_SFR_UMR_OFFSET     8			/* uartM[hWX^ */
#define	TADR_SFR_UBRG_OFFSET    9			/* uart{[[gWFl[^ */
#define	TADR_SFR_UTB_OFFSET     10			/* uartMobt@WX^ */
#define	TADR_SFR_UC0_OFFSET     12			/* uartM䃌WX^#0 */
#define	TADR_SFR_UC1_OFFSET     13			/* uartM䃌WX^#1 */
#define	TADR_SFR_URB_OFFSET     14			/* uartMobt@WX^ */

/*
 *  A-D/D-AWX^
 */
#define TADR_SFR_AD00            0x380			/* A-DWX^O */
#define TADR_SFR_AD01            0x382			/* A-DWX^P */
#define TADR_SFR_AD02            0x384			/* A-DWX^Q */
#define TADR_SFR_AD03            0x386			/* A-DWX^R */
#define TADR_SFR_AD04            0x388			/* A-DWX^S */
#define TADR_SFR_AD05            0x38a			/* A-DWX^T */
#define TADR_SFR_AD06            0x38c			/* A-DWX^U */
#define TADR_SFR_AD07            0x38e			/* A-DWX^V */
#define TADR_SFR_AD0CON2         0x394			/* A-D䃌WX^Q */
#define TADR_SFR_AD0CON0         0x396			/* A-D䃌WX^O */
#define TADR_SFR_AD0CON1         0x397			/* A-D䃌WX^P */

#define TADR_SFR_AD10            0x1c0			/* A-DWX^O */
#define TADR_SFR_AD11            0x1c2			/* A-DWX^P */
#define TADR_SFR_AD12            0x1c4			/* A-DWX^Q */
#define TADR_SFR_AD13            0x1c6			/* A-DWX^R */
#define TADR_SFR_AD14            0x1c8			/* A-DWX^S */
#define TADR_SFR_AD15            0x1ca			/* A-DWX^T */
#define TADR_SFR_AD16            0x1cc			/* A-DWX^U */
#define TADR_SFR_AD17            0x1ce			/* A-DWX^V */
#define TADR_SFR_AD1CON2         0x1d4			/* A-D䃌WX^Q */
#define TADR_SFR_AD1CON0         0x1d6			/* A-D䃌WX^O */
#define TADR_SFR_AD1CON1         0x1d7			/* A-D䃌WX^P */

#define TADR_SFR_DA0            0x398			/* D-AWX^O */
#define TADR_SFR_DA1            0x39a			/* D-AWX^P */
#define TADR_SFR_DACON          0x39c			/* D-A䃌WX^ */

/*
 *  ėp|[gWX^(ꕔA144sł̂)
 */
#define TADR_SFR_P0             0x3e0           /* |[gP0WX^ */
#define TADR_SFR_P1             0x3e1           /* |[gP1WX^ */
#define TADR_SFR_PD0            0x3e2		/* |[gP0WX^ */
#define TADR_SFR_PD1            0x3e3		/* |[gP1WX^ */
#define TADR_SFR_P2             0x3e4		/* |[gP2WX^ */
#define TADR_SFR_P3             0x3e5		/* |[gP3WX^ */
#define	TADR_SFR_PD2            0x3e6		/* |[gP2WX^ */
#define	TADR_SFR_PD3            0x3e7		/* |[gP3WX^ */
#define TADR_SFR_P4             0x3e8		/* |[gP4WX^ */
#define	TADR_SFR_P5             0x3e9		/* |[gP5WX^ */
#define	TADR_SFR_PD4            0x3ea		/* |[gP4WX^ */
#define	TADR_SFR_PD5            0x3eb		/* |[gP5WX^ */
#define TADR_SFR_P6             0x3c0		/* |[gP6WX^ */
#define	TADR_SFR_P7             0x3c1		/* |[gP7WX^ */
#define	TADR_SFR_PD6            0x3c2		/* |[gP6WX^ */
#define	TADR_SFR_PD7            0x3c3		/* |[gP7WX^ */
#define	TADR_SFR_P8             0x3c4		/* |[gP8WX^ */
#define TADR_SFR_P9             0x3c5		/* |[gP9WX^ */
#define	TADR_SFR_PD8            0x3c6		/* |[gP8WX^ */
#define TADR_SFR_PD9            0x3c7		/* |[gP9WX^ */
#define TADR_SFR_P10            0x3c8		/* |[gP10WX^ */
#define TADR_SFR_P11            0x3c9		/* |[gP11WX^(144sł̂) */
#define TADR_SFR_PD10           0x3ca		/* |[gP10WX^ */
#define TADR_SFR_PD11           0x3cb		/* |[gP11WX^(144sł̂) */
#define TADR_SFR_P12            0x3cc		/* |[gP12WX^(144sł̂) */
#define TADR_SFR_P13            0x3cd		/* |[gP13WX^(144sł̂) */
#define TADR_SFR_PD12           0x3ce		/* |[gP12WX^(144sł̂) */
#define TADR_SFR_PD13           0x3cf		/* |[gP13WX^(144sł̂) */
#define TADR_SFR_P14            0x3d0		/* |[gP14WX^(144sł̂) */
#define TADR_SFR_P15            0x3d1		/* |[gP15WX^(144sł̂) */
#define TADR_SFR_PD14           0x3d2		/* |[gP14WX^(144sł̂) */
#define TADR_SFR_PD15           0x3d3		/* |[gP15WX^(144sł̂) */

#define	TADR_SFR_PUR0           0x3f0		/* vAbv䃌WX^O */
#define	TADR_SFR_PUR1           0x3f1		/* vAbv䃌WX^P */
#define	TADR_SFR_PUR2           0x3da		/* vAbv䃌WX^Q */
#define	TADR_SFR_PUR3           0x3db		/* vAbv䃌WX^R */
#define	TADR_SFR_PUR4           0x3dc		/* vAbv䃌WX^S(144sł̂) */

#define	TADR_SFR_PCR            0x3ff		/* |[g䃌WX^ */

#define TADR_SFR_PS0            0x3b0		/* @\IWX^A0 */
#define TADR_SFR_PS1            0x3b1		/* @\IWX^A1 */
#define TADR_SFR_PS2            0x3b4		/* @\IWX^A2 */
#define TADR_SFR_PS3            0x3b5		/* @\IWX^A3 */
#define TADR_SFR_PS5            0x3b9		/* @\IWX^A5(144sł̂) */
#define TADR_SFR_PS6            0x3bc		/* @\IWX^A6(144sł̂) */
#define TADR_SFR_PS7            0x3bd		/* @\IWX^A7(144sł̂) */
#define TADR_SFR_PS8            0x3a0		/* @\IWX^A8(144sł̂) */
#define TADR_SFR_PS9            0x3a1		/* @\IWX^A9(144sł̂) */

#define TADR_SFR_PSL0           0x3b2		/* @\IWX^B0 */
#define TADR_SFR_PSL1           0x3b3		/* @\IWX^B1 */
#define TADR_SFR_PSL2           0x3b6		/* @\IWX^B2 */
#define TADR_SFR_PSL3           0x3b7		/* @\IWX^B3 */

#define TADR_SFR_PSC            0x3af		/* @\IWX^C */


/*
 *  M䃌WX^1 (UART0,UART1)
 */
#define	TBIT_UiC1_RI	0x08	/* MtO */
#define	TBIT_UiC1_RE	0x04	/* Mrbg */
#define	TBIT_UiC1_TI	0x02	/* Mobt@tO */
#define	TBIT_UiC1_TE	0x01	/* Mrbg */

#define TBIT_UiC0_TXEPT	0x08	/* MWX^tO */

/*
 *  ݐ䃌WX^
 */
#define	TBIT_TAiIC_IR	0x08

/*
 *  JEgJntO (TABSR)
 */
#define TBIT_TABSR_TA0S	0x01

/*
 *  Abv_EtO(UDF)
 */
#define TBIT_UDF_TA0UD	0x01


/*
 *  |[gVݒ
 */
//#define	P7_LED1					0x10			/* LED1rbg` */
//#define	P7_LED2					0x20			/* LED2rbg` */

#ifndef _MACRO_ONLY

#include "cpu_defs.h"

/*
 *  ^[QbgVXe̕o
 */

Inline void
oaks32_putc(char c)
{
	char enabled;
	volatile char * p = (volatile char *)TADR_SFR_UART0_BASE;

	/* MĂȂ΋ */
	enabled = p[TADR_SFR_UC1_OFFSET] & TBIT_UiC1_TE;
	if(!enabled) {
		p[TADR_SFR_UC1_OFFSET] |= TBIT_UiC1_TE;
	}

	/* Mobt@ɂȂ܂ő҂(Lԓ̏) */
	while((p[TADR_SFR_UC1_OFFSET] & TBIT_UiC1_TI) == 0);

	/* 1M */
	p[TADR_SFR_UTB_OFFSET] = c;

	if(!enabled) {
		p[TADR_SFR_UC1_OFFSET] &= ~TBIT_UiC1_TE;
	}
}

#endif /* _MACRO_ONLY */
#endif /* _OAKS32_H_ */

