/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2003-2004 by Naoki Saito
 *             Nagoya Municipal Industrial Research Institute, JAPAN
 *  Copyright (C) 2003-2004 by Ryosuke Takeuchi
 *              Platform Development Center RICOH COMPANY,LTD. JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: cpu_config.h,v 1.1 2008/06/17 00:04:46 suikan Exp $
 */


/*
 *  vZbTˑW[iM32Cpj
 *
 *  ̃CN[ht@ĆCt_config.h ݂̂CN[hD
 *  ̃t@C璼ڃCN[hĂ͂ȂȂD
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

#ifdef NEED_API
#include "api.h"
#endif /* NEED_API */

/*
 *  J[l̓ʖ̃l[
 */
#include <cpu_rename.h>

/*
 *  vZbT̓ꖽ߂̃CC֐`
 */
#ifndef _MACRO_ONLY
#include <cpu_insn.h>
#endif /* _MACRO_ONLY */

/*
 *  TCB ̃tB[h̃rbg̒`
 *
 *  cpu_context.h ɓGKgCQƂ̈ˑ̊֌WŁC
 *  cpu_context.h ɂ͓ȂD
 */
#define TBIT_TCB_TSTAT		8	/* tstat tB[h̃rbg */
#define TBIT_TCB_PRIORITY	4	/* priority tB[h̃rbg */

#ifndef _MACRO_ONLY

/*
 *  ^XNReLXgubN̒`
 */
typedef struct task_context_block {
	VP	sp;	/*  X^bN|C^  */
	FP	pc;	/*  vOJE^  */
} CTXB;

/* 
 *  /CPUOlXgJE^
 */
extern char	intnest;

/*
 *  VXeԂ̎Q
 */

/*
 *  ݂̃ReLXgԂ֐.
 *  ^XNReLXgȂTRUEԂ.
 */
Inline BOOL
sense_context(void)
{
	/*  lXgJE^0Ȃ^XNReLXg  */
	return(intnest > 0);
}

/*
 *  ݂CPUbNԂԂ֐.
 *  CPUbNԂȂTRUEԂ.
 */
Inline BOOL
sense_lock(void)
{
	return((current_flgreg() & FLG_I_MASK) == 0);
}

#define t_sense_lock	sense_lock
#define i_sense_lock	sense_lock

/*
 *  CPUbNƂ̉
 */
Inline void
lock_cpu(void)
{
	disint();
}

Inline void
unlock_cpu(void)
{
	enaint();
}

#define t_lock_cpu	lock_cpu
#define i_lock_cpu	lock_cpu
#define t_unlock_cpu	unlock_cpu
#define i_unlock_cpu	unlock_cpu

/*
 *  ^XNfBXpb`
 */

/*
 *  ōD揇ʃ^XNւ̃fBXpb`icpu_support.a30j
 *
 *  dispatch ́C^XNReLXgĂяoꂽ
 *  T[rXR[̒CCPUbNԂŌĂяoȂ΂ȂȂD
 */
extern void	dispatch(void);

/*
 *  ݂̃ReLXĝĂăfBXpb`(cpu_support.a30)
 *  exit_and_dispatch ́CCPUbNԂŌĂяoȂ΂ȂȂD
 */
extern void	exit_and_dispatch(void);

/*
 *  ݃nh^CPUOnh̐ݒ
 */

/*
 *  ݃nh̐ݒ
 *
 *  xNgԍ inhno ̊݃nh̋NԒn inthdr ɐݒ肷D
 *  ݃nho^xN^e[uROMɎ,
 *  ɏ. ̂߂ł͉ȂD
 */

Inline void
define_inh(INHNO inhno, FP inthdr)
{
}

/*
 *  CPUOnh̐ݒ
 *
 *  xNgԍ excno CPUOnh̋NԒn exchdr ɐݒ肷D
 *  ݃nho^xN^e[uROMɎ,
 *  ɏ. ̂߂ł͉ȂD
 */
Inline void
define_exc(EXCNO excno, FP exchdr)
{
}

/*
 *  ݃nh^CPUOnh̏oO
 *
 *  ݁^CPUOCPȔԂ͎̂Ƃ.
 *
 *  FLGWX^Irbg 0(݋֎~) 
 *  FLGWX^IPL͎󂯕t݂IPL
 *  FLGWX^Urbg, ݂̎ނɂĈقȂ邪,
 *  J[lłISP݂̂gp, USPgpĂȂ,
 *  ł͖ƂȂȂ.
 *
 *  /Oɂ, I FLG, PCX^bN֕ۑ.
 *  oł͂܂c̃WX^X^bNɕۑ.
 *  i݂̊̏ꍇ̓^XÑX^bN,
 *  d荞݂̏ꍇ͊ݗp̃X^bN, ꂼۑ.
 *
 *  ̌, X^bN|C^̒l r3r1 , 
 *  ݃nh̃AhX a0 Ɋi[Ԃ
 *  ݏǒ㔼փWv.
 */

/*
 *  ݃nh̏o̐}N
 *
 *  ݔAs̃WX^̒lX^bNɑޔĎAX
 *  ^bN|C^̒lR3R1WX^ɃZbgAAZuŋLqꂽ
 *  nhOvOɕ򂷂D
 */

#define INTHDR_ENTRY(inthdr)\
extern void inthdr##_entry(void);\
asm("	.glb _" #inthdr "						");\
asm("	.glb __kernel_interrupt						");\
asm("	.section program, code, align					");\
asm("_" #inthdr "_entry:						");\
asm("	pushm	r0,r1,r2,r3,a0,a1,sb,fb	; WX^^XNX^bN֑ޔ");\
asm("	stc	isp, r3r1		; X^bN|C^o	");\
asm("	mov.l	#_" #inthdr ", a0	; ݃nh̃AhXa0");\
asm("	jmp	__kernel_interrupt	; ݏ[`㔼	");

#define INT_ENTRY(inthdr)	inthdr##_entry

/*
 *  CPUOnh̏o̐}N
 */
#define EXC_ENTRY(exchdr)	INT_ENTRY(exchdr)
#define EXCHDR_ENTRY(exchdr)	INTHDR_ENTRY(exchdr)


/*
 *  CPUO̔̃VXeԂ̎Q
 */

/*
 *  CPUO̔̃ReLXg̎Q
 */
Inline BOOL
exc_sense_context(VP p_excinf)
{
	/* 
	 *  lXgJE^1Ȃ^XNReLXg
	 */
	return( intnest > 1);
}

/*
 *  CPUO̔CPUbNԂ̎Q
 */
Inline BOOL
exc_sense_lock(VP p_excinf)
{
	/*
	 *  OOFLGWX^Irbg0ȂCPUbN
	 *
	 *  ̒萔28CPUOŃWX^X^bNɂǂ
	 *  ۑĂ邩ɈˑČ肷鐔l
	 */
	return( ( *(char *)((char *)p_excinf+28) & FLG_I_MASK ) == 0);
}

/*
 *  vZbTˑ̏(cpu_config.c)
 */
extern void	cpu_initialize(void);

/*
 *  vZbTˑ̏I(cpu_config.c)
 */
extern void	cpu_terminate(void);

#endif /* _MACRO_ONLY */
#endif /* _CPU_CONFIG_H_ */
