/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

#define _MACRO_ONLY

#include <t_config.h>	/* CCR_I, MAX_IPM */

/*
 *  H8SpX^[gAbvW[
 *  J[l̓AvP[VƃNĎgp
 *  Ȃ̂JSPJ[l̂ݎgpB
 */
	.h8300s

	.text
	.align 2

	.global	start
	.global bss_clear	/* hardware_init_hook ̖߂AhX */

start:

	/*
	 *  ^XNƗ̃X^bNSTACKTOPɏ
	 *  iSTACKTOṔAsys_config.hŒ`j
	 *  En[hEFA}jA u4.2.4 Zbg̊݁v(P90)
	 *    vO̐擪߂ SP ̏߂łȂ΂ȂȂB
	 */
	mov.l	#STACKTOP, sp

	/*
	 *  CCR ̏
	 *  Eݐ䃂[h0 ɂ銄݋֎~ (I = 1 ; CCR)
	 *    ( _hardware_init_hook Ŋݐ䃂[hύX܂ł́A
	 *     ݐ䃂[h0łB)
	 */
	ldc.b	#CCR_I, ccr

	/*
	 *  EXR ̏
	 *  Eݐ䃂[h2 ɂ銄݋֎~ (I2, I1, I0 = 1 ; CCR)
	 */
	ldc.b	#MAX_IPM, exr

	/*
	 *  hardware_init_hook ĂяoB(0łȂꍇ)
	 *  E^[Qbgn[hEFAɈˑ鏉ꍇ́C
	 *    hardware_init_hook Ƃ֐pӂD
	 *      jROM̍ہARAMgp\ɂ邽߂̃oXRg[̏
	 *    ́Asys_support.S  hardware_init_hook `ĂD
	 */
hardware_init:
	mov.l	@_hardware_init_hook_k, er0
	or.l	er0, er0
	beq	bss_clear		/* er0 = 0 Ȃ bss_clear  */
	jmp	@er0

	/*
	 * bssZNVNA
	 */
bss_clear:
	mov.l	#__bss_start, er0
	mov.l	#_end, er1
	sub.l	er2, er2
loop_bss_clear:
	mov.l	er2, @er0
	add.l	#4, er0
	cmp.l	er1, er0
	blo	loop_bss_clear		/* er1 > er0 ܂ŃWv */

	/*
	 *  dataZNViROMΉj
	 *
	 *  __idata_start  __idata_end ܂łC__data_start ȍ~ɃRs[
	 */
data_sec_copy:
	mov.l	#__idata_start, er0
	mov.l	#__idata_end, er1
	mov.l	#__data_start, er2
loop_data_sec_copy:
	mov.l	@er0+, er4		/* *er2++ = *er0 ++; */
	mov.l	er4, @er2
	add.l	#4, er2
	cmp.l	er1, er0
	blo	loop_data_sec_copy	/* er1 > er0 ܂ŃWv */

	/*
	 *  software_init_hook Ăяoi0 łȂꍇj
	 *
	 *  \tgEFAiɃCujɈˑĕKvȏ
	 *  ꍇ́Csoftware_init_hook Ƃ֐pӂD
	 */
software_init:
	mov.l	@_software_init_hook_k, er0
	or.l	er0, er0
	beq	start_kernel
	jsr	@er0

	/*
	 *  J[lN
	 */
start_kernel:
	jmp	@_kernel_start

	.align 4
_hardware_init_hook_k:
	.long   _hardware_init_hook
_software_init_hook_k:
	.long   _software_init_hook
