/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

#include <h8s_tpu.h>

/*
 *   ^C}hCoiH8St@~[pj
 *     H8St@~[ɂ́ATPU(16bit^C})  8bit^C} ̂Qނ
 *     ĂA̓ږ{́AevZbTɂقȂB
 *     {ł́ATPU(16bit^C}) 𗘗pĂBiɃ`lOj
 *     H8SvZbTɂāA8bit^C} 𗘗pꍇ́AύX
 *     sKvB
 */

/*
 *  ^C}݃nh̃xN^ԍ
 */
#define	INHNO_TIMER	IRQ_TGI0A

#ifndef _MACRO_ONLY

/*
 *  ^C}l̓\̌^
 */
typedef UH	CLOCK;

#endif	/* _MACRO_ONLY */

/*
 *  ^C}̒Pʂ\ɕϊ
 *  	jsp/kernel/time_manage.cłgp
 */
#define TO_CLOCK(nume, deno)	(TIMER_CLOCK * (nume) / (deno))
#define TO_USEC(clock)		((clock) * 1000 / TIMER_CLOCK)

/*
 *  ^C}̒Pʂ\ɕϊ
 */
#define CLOCK_PER_TICK	((CLOCK) TO_CLOCK(TIC_NUME, TIC_DENO))

/*
 *  ݒłő̃^C}iPʂ͓\j
 */
#define MAX_CLOCK	((CLOCK) 0xffff)

/*
 *  \]pVXeoۂ̏Ԃ̌ςl
 *	iPʂ͓\j
 *	Ӂi{͕NbNɈˑj
 */

#define GET_TOLERANCE	100u
#define	BEFORE_IREQ(clock) \
		((clock) >= TO_CLOCK(TIC_NUME, TIC_DENO) - GET_TOLERANCE)

#ifndef _MACRO_ONLY

/*
 *  ^C}ݗṽNA
 */
Inline void
hw_timer_int_clear(void)
{
	/* `lO̊荞ݗvNA (TGFA = 0) */
	h8s_andb_reg( (VP) TSR0, ~TGFA );
}

/*
 *  ^C}̋N
 *    ^C}CIȃ^C}ݗv𔭐D
 */
Inline void
hw_timer_initialize(void)
{
	/* W[Xgbv[h */
	h8s_andh_reg( (VP) MSTPCR, ~MSTPCR_TPU );

	/* `lO̓~ */
	h8s_andb_reg( (VP) TSTR, ~CST0 );

	/* TCR ̐ݒ
	   ETGRARyA}b`ŃJE^NA(CCLR = 1)
	   EオGbWŃJEg(CKEG1,0 = 0)
	A ENbN/4ŃJEg(ݒGTPSC0 =1) */
	h8s_wrb_reg( (VP) TCR0, (CCLR0 | TPSC0) );

	/* TIER ̐ݒ
	   ETGFArbgɂ銄ݗv */
	h8s_wrb_reg( (VP) TIER0, TGIEA );

	/* TIOR ̐ݒ
	   ETGRARyA}b`ɂ[qo͋֎~ */
	/* ݒ肷ׂ͖̂B */

	/* TGR0A ̐ݒ
	   ETGRAWX^ݒiJE^ڕWlj*/
	h8s_wrh_reg( (VP) TGR0A, CLOCK_PER_TICK );

	h8s_wrh_reg( (VP) TCNT0, 0 );		/* JE^NA */

	/*
	 *  ݊֘A̐ݒ
	 */
	icu_set_ilv( IPRF, IPR_UPR, TPU0_INT_LVL );
						/* ݃xݒ */
	hw_timer_int_clear();			/* ݗvNA */

	/* `lO̓Jn */
	h8s_orb_reg( (VP) TSTR, CST0 );
}

/*
 *  ^C}̒~
 */
Inline void
hw_timer_terminate(void)
{
	/* `lO̓~ */
	h8s_andb_reg( (VP) TSTR, ~CST0 );

	hw_timer_int_clear();			/* ݗvNA */
}

/*
 *  ^C}̌ݒl̓ǂݏo
 *    ݋֎~ԒŌĂяoƁD
 */
Inline CLOCK
hw_timer_get_current(void)
{
	/* AbvJE^Ȃ̂ */
	return( (CLOCK) h8s_reh_reg( (VP) TCNT0 ) );
}

/*
 *  ^C}ݗṽ`FbN
 */
Inline BOOL
hw_timer_fetch_interrupt(void)
{
	return( h8s_reb_reg( (VP) TSR0 ) & TGFA );
}

#endif	/* _MACRO_ONLY */

#endif /* _HW_TIMER_H_ */
