/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

#ifndef _H8S_TPU_H_
#define _H8S_TPU_H_

#include <s_services.h>		/* foCXhCopWCN[ht@C */

/*
 *  H8S16rbg^C}pXjbg(TPU)֘A̒`
 */

/* TPUWX^̃AhX */

/* `lO */
#define TCR0		0xffd0		/* ^C}Rg[WX^O */
#define TMDR0		0xffd1		/* ^C}[hWX^O */
#define TIOR0H		0xffd2		/* ^C}I/ORg[WX^Og */
#define TIOR0L		0xffd3		/* ^C}I/ORg[WX^Ok */
#define TIER0		0xffd4		/* ^C}C^vgCl[uWX^O */
#define TSR0		0xffd5		/* ^C}Xe[^XWX^O */
#define TCNT0		0xffd6		/* ^C}JE^O */
#define TGR0A		0xffd8		/* ^C}WFlWX^O` */
#define TGR0B		0xffda		/* ^C}WFlWX^Oa */
#define TGR0C		0xffdc		/* ^C}WFlWX^Ob */
#define TGR0D		0xffde		/* ^C}WFlWX^Oc */

/* `lP */
#define TCR1		0xffe0		/* ^C}Rg[WX^P */
#define TMDR1		0xffe1		/* ^C}[hWX^P */
#define TIOR1		0xffe2		/* ^C}I/ORg[WX^P */
#define TIER1		0xffe4		/* ^C}C^vgCl[uWX^P */
#define TSR1		0xffe5		/* ^C}Xe[^XWX^P */
#define TCNT1		0xffe6		/* ^C}JE^P */
#define TGR1A		0xffe8		/* ^C}WFlWX^P` */
#define TGR1B		0xffea		/* ^C}WFlWX^Pa */

/* `lQ */
#define TCR2		0xfff0		/* ^C}Rg[WX^Q */
#define TMDR2		0xfff1		/* ^C}[hWX^Q */
#define TIOR2		0xfff2		/* ^C}I/ORg[WX^Q */
#define TIER2		0xfff4		/* ^C}C^vgCl[uWX^Q */
#define TSR2		0xfff5		/* ^C}Xe[^XWX^Q */
#define TCNT2		0xfff6		/* ^C}JE^Q */
#define TGR2A		0xfff8		/* ^C}WFlWX^Q` */
#define TGR2B		0xfffa		/* ^C}WFlWX^Qa */

/* `lR */
#define TCR3		0xfe80		/* ^C}Rg[WX^R */
#define TMDR3		0xfe81		/* ^C}[hWX^R */
#define TIOR3H		0xfe82		/* ^C}I/ORg[WX^Rg */
#define TIOR3L		0xfe83		/* ^C}I/ORg[WX^Rk */
#define TIER3		0xfe84		/* ^C}C^vgCl[uWX^R */
#define TSR3		0xfe85		/* ^C}Xe[^XWX^R */
#define TCNT3		0xfe86		/* ^C}JE^R */
#define TGR3A		0xfe88		/* ^C}WFlWX^R` */
#define TGR3B		0xfe8a		/* ^C}WFlWX^Ra */
#define TGR3C		0xfe8c		/* ^C}WFlWX^Rb */
#define TGR3D		0xfe8e		/* ^C}WFlWX^Rc */

/* `lS */
#define TCR4		0xfe90		/* ^C}Rg[WX^S */
#define TMDR4		0xfe91		/* ^C}[hWX^S */
#define TIOR4		0xfe92		/* ^C}I/ORg[WX^S */
#define TIER4		0xfe94		/* ^C}C^vgCl[uWX^S */
#define TSR4		0xfe95		/* ^C}Xe[^XWX^S */
#define TCNT4		0xfe96		/* ^C}JE^S */
#define TGR4A		0xfe98		/* ^C}WFlWX^S` */
#define TGR4B		0xfe9a		/* ^C}WFlWX^Sa */

/* `lT */
#define TCR5		0xfea0		/* ^C}Rg[WX^T */
#define TMDR5		0xfea1		/* ^C}[hWX^T */
#define TIOR5		0xfea2		/* ^C}I/ORg[WX^T */
#define TIER5		0xfea4		/* ^C}C^vgCl[uWX^T */
#define TSR5		0xfea5		/* ^C}Xe[^XWX^T */
#define TCNT		0xfea6		/* ^C}JE^T */
#define TGR5A		0xfea8		/* ^C}WFlWX^T` */
#define TGR5B		0xfeaa		/* ^C}WFlWX^Ta */

/*  */
#define TSTR		0xffc0		/* ^C}Xe[gWX^ */
#define TSYR		0xffc1		/* ^C}VNWX^ */

/* eWX^̃rbgp^[ */

/* TCR */
#define CCLR2		BIT7		/* `lOAR̂ */
#define CCLR1		BIT6
#define CCLR0		BIT5
#define CKEG1		BIT4
#define CKEG0		BIT3
#define TPSC2		BIT2
#define TPSC1		BIT1
#define TPSC0		BIT0

/* TMDR */
#define BFB		BIT5		/* `lOAR̂ */
#define BFA		BIT4		/* `lOAR̂ */
#define MD3		BIT3
#define MD2		BIT2
#define MD1		BIT1
#define MD0		BIT0

/* TIOR */
/* TIORxA܂́ATIORxH */
#define IOB3		BIT7
#define IOB2		BIT6
#define IOB1		BIT5
#define IOB0		BIT4
#define IOA3		BIT3
#define IOA2		BIT2
#define IOA1		BIT1
#define IOA0		BIT0

/* TIORxL */
#define IOD3		BIT7
#define IOD2		BIT6
#define IOD1		BIT5
#define IOD0		BIT4
#define IOC3		BIT3
#define IOC2		BIT2
#define IOC1		BIT1
#define IOC0		BIT0

/* TIER */
#define TTGE		BIT7
#define TCIEU		BIT5		/* `lPCQCSCT̂ */
#define TCIEV		BIT4
#define TGIED		BIT3		/* `lOCR̂ */
#define TGIEC		BIT2		/* `lOCR̂ */
#define TGIEB		BIT1
#define TGIEA		BIT0

/* TSR */
#define TCFD		BIT7
#define TCFU		BIT5		/* `lPCQCSCT̂ */
#define TCFV		BIT4
#define TGFD		BIT3		/* `lOCR̂ */
#define TGFC		BIT2		/* `lOCR̂ */
#define TGFB		BIT1
#define TGFA		BIT0

/* TCNT, TGR */
/* `ׂ̂́Aɖ */

/* TSTR */
#define CST5		BIT5
#define CST4		BIT4
#define CST3		BIT3
#define CST2		BIT2
#define CST1		BIT1
#define CST0		BIT0

/* TSYR */
#define SYNC5		BIT5
#define SYNC4		BIT4
#define SYNC3		BIT3
#define SYNC2		BIT2
#define SYNC1		BIT1
#define SYNC0		BIT0

#endif /* _H8S_TPU_H_ */
