/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: cpu_support.S,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */

/*
 *	vZbTˑW[ AZuꕔiH8pj
 */

#define _MACRO_ONLY
#include "jsp_kernel.h"
#include "offset.h"

/*
 *  NMIׂĂ݂̊֎~
 */
#define DISINT	orc.b  #H8INT_DIS_ALL, ccr

/*
 *  ׂĂ݂̊
 */
#define ENAINT	andc.b #H8INT_ENA_ALL, ccr


	.h8300h

	.text
	.align 2

/*
 *  ^XNfBXpb`
 *
 *    @_dispatch ́A݊OlXgJE^ = 0,݋֎~
 *    ŌĂяoȂ΂ȂȂDexit_and_dispatch C݃lXg
 *    JE^ = 0E݋֎~ԂŌĂяôł邪CJ[l
 *    NɑΉ邽߁C݃lXgJE^ = 1ŌĂяoꍇ
 *    ΉĂD
 */

	.global _dispatch
_dispatch:
	push.l	er4			/*  er4`6ۑ		*/
	push.l	er5
	push.l	er6
	mov.l	@_runtsk, er0		/* er0 <- runtsk		*/
	mov.l	sp, @(TCB_sp, er0)	/* ^XNX^bN|C^ۑ	*/
	mov.l	#dispatch_r, er1	/* sĊJԒn			*/
	mov.l	er1, @(TCB_pc, er0)
	bra     dispatcher

dispatch_r:
	pop.l	er6			/*  er4`6𕜌		*/
	pop.l	er5
	pop.l	er4
	mov.l	@_runtsk, er0
	mov.b	@(TCB_enatex, er0), r1l	/* runtsk->enatex ̃`FbN	*/
	btst	#TCB_enatex_bit, r1l
	beq	dispatch_r_1
	mov.l	@(TCB_texptn, er0), er1	/* runtsk->texptn ̃`FbN	*/
	beq	dispatch_r_1
	jmp	@_call_texrtn

dispatch_r_1:
	rts			/*  dispatch()̌Ăяoփ^[  */

	.global	_exit_and_dispatch
_exit_and_dispatch:
	/* 荞݋֎~ŌĂ΂ */
        mov.b   #0, r0l         	/* ݃lXgJE^NA	*/
        mov.b   r0l, @_intnest

/*  
 *@fBXpbe{
 */
dispatcher:
	/*
	 * ɂ͊荞݋֎~ŗ邱
	 */

	/*
	 * runtskschedtsk̂͂Q̈ӖB
	 * @(1) schedtsk != NULL̏ꍇ
	 * @@@@ʏ̃^XN؂ւsB
	 * @(2) schedtsk == NULL̏ꍇ
	 * @@@@runtskNULLĂB
	 * @@@@idispatcher_1ȍ~̊ݑ҂Ŋ݂A̒
	 * @@@@@iget_tid()R[ꂽƂɐTSK_NONEԂ
	 * @@@@@ɂ́AsԂ̃^XNȂɁAruntskNULLɂ
	 * @@@@@KvBj
	 */
	mov.l	@_schedtsk, er0		/* er0 <- schedtsk		*/
	mov.l	er0, @_runtsk		/* schedtskruntsk		*/
			/*  sׂ^XNȂ΁Aݑ҂֕  */
	beq	dispatcher_1
	mov.l	@(TCB_sp, er0), sp
	mov.l	@(TCB_pc, er0), er0	/* sĊJԒn𕜋A		*/
	jmp	@er0


	/*
	 *  sׂ^XNȂꍇ̊ݑ҂
	 *  
	 *  Ŋ݃[hɐ؂芷̂́CŔ銄ݏ
	 *  ɂǂ̃X^bNgƂ̉ƁC݃nh
	 *  ̃^XNfBXpb`̖h~Ƃ̈ӖD
	 */
dispatcher_1:
	    			/* X^bN荞݃X^bNɐؑւ	*/
	mov.l	#STACKTOP, sp
				/*  ݃lXgJE^Pɂ	*/
        mov.b   #1, r0l
        mov.b   r0l, @_intnest

	/*
	 * r1lF݋ccrɐݒ肷l
	 *@@@݃nhłchg_ipmgpłȂ̂ŁA
	 *@@@task_intmask1ǂݍł΁AOK
	 */
#ifdef SUPPORT_CHG_IPM
        mov.b     @_task_intmask, r1l
#else	/* SUPPORT_CHG_IPM */
        mov.b     #H8INT_ENA_ALL, r1l
#endif	/* SUPPORT_CHG_IPM */

	/* CPUbNtONA */
	sub.l	er0, er0
        mov.l   er0, @_iscpulocked


dispatcher_2_enable_interrupt:
        /*
         *@ldcߒ͊݋֎~łAݗvĂ
         *@̖߂sB
         *@i݂߂ĂsleepP[X͂Ȃj
         */
        ldc.b     r1l, ccr              /* 荞݋ */
        sleep                           /* ݑ҂ */
        DISINT                          /* 荞݋֎~ */

	mov.l   @_reqflg, er0           /* reqflg̃`FbN */
			/* reqflgBOOL^ -> int^(32bits) */
		/*  reqflg==NULLȂ΁A1xݑ҂  */
	beq     dispatcher_2_enable_interrupt
	sub.l	er0, er0
	mov.l   er0, @_reqflg		/* reqflg̃NA */
			/* ݃lXgJE^NA	*/
	mov.b   r0l, @_intnest
	bra	dispatcher

/*
 *
 *  ݃nh
 *@@ݗvɈ˂炸Aʂȕ
 *@@icpu_config.hINTHDR_ENTRY̑j
 *
 *@@@@ȉ̏ԂłɂĂ
 *@@@@@E݋֎~
 *@@@@@Eer0`er3ޔς
 *@@@@@Eer2FCꃋ[`̐擪AhX
 *@@@@@Er3lF݋Ɋ݃}XNɐݒ肷l
 */
        .global _common_interrupt_process
_common_interrupt_process:
	push.l	er4			/*  œK΍er4ޔ  */
        mov.b   @_intnest, r0l          /* ݃lXgJE^̃`FbN */
        bne     _interrupt_from_int     /*  intnet0łȂ΁A*/
        				/*  d݂̏  */

        /*
         *@i݂̊̏ꍇ
         */
        mov.b   #1, r1l                 /* ݃lXgJE^P */
        mov.b   r1l, @_intnest
        mov.l   sp, er0
        mov.l   #STACKTOP, sp           /* X^bNؑ */
        push.l  er0                     /* ^XNX^bN|C^̑ޔ */
        ldc.b   r3l, ccr                /* ݋ */
        jsr     @er2                    /* Cꃋ[`Ăяo */
        DISINT                          /* ݋֎~ */
        mov.b   #0, r0l                 /* ݃lXgJE^̃NA */
        mov.b   r0l, @_intnest
        mov.l   @sp, sp                 /* X^bNؑ */
        mov.l   @_reqflg, er0           /* reqflg̃`FbN */
        beq     _ret_to_task_int        /* reqflgFALSEȂ */
        				/* ret_to_task_intɔ */
        sub.l	er0, er0
        mov.l   er0, @_reqflg           /* reqflgNA */
        bra     ret_int                 /* oփWv */

        /*
         *@d݂̏ꍇ
         *@@݋֎~łɂĂ
         *
         *@@݃lXgJE^̃CNg͈ȉ̗R
         *@@ȗĂ
         *@@@E݂2xȂ
         *@@@ECPUOT|[gȂ
         *@@@@@exc_sense_context()̂ƂlȂĂǂ
         */
_interrupt_from_int:
        /* ݃lXgJE^̃CNg͏ȗ */
        ldc.b   r3l, ccr                /* ݋ */
        jsr     @er2                    /* Cꃋ[`Ăяo */
        DISINT                          /* ݋֎~ */
        /* ݃lXgJE^̃fBNg͏ȗ */

        /*
         *@{͂Ŗ߂悪Aݑ҂sleep߂ǂ̃`Fb
         *@NKvłBiA݃nhreqflg=TRUEɂ
         *@fBXpb`Ă΂Ȃ^XNsȂj
         *@H8̏ꍇAsleep߂̒Oɂ銄݋ldc߂̎s
         *@͊݋֎~łAݗvƂĂ݂͎
         *@tȂŁAsleep߂sB̂߁A݂
         *@߂sleep߂sP[X͍lȂėǂB
         */

        /*
         *@fBXpb`Ă΂ɁA݌ɖ߂ꍇ
         */
_ret_to_task_int:
					/* WX^𕜌 */
	pop.l	er4			/*  er4͍œK΍  */
        pop.l   er3
        pop.l   er2
        pop.l   er1
        pop.l   er0
        rte                             /* ݌փ^[ */

/*
 * oɂăX^bN|C^wĂԒnCCRWX^
 * ς܂ĂԒn܂ł̃ItZbg̒`
 *
 *@ +0:er4
 *@ +4:er3
 *@ +8:er2
 *@+12:er1
 *@+16:er0
 *  +20:ccr sp΃ANZX
 */
#define OFFSET_CCR	20

/*
 *  ݃nho
 *
 * ߂悪^XNreqflgZbgĂꍇ݂̂ɂB
 * ݃lXgJE^ = 0,݋֎~,XNb`WX^
 * ۑԂŌĂяoƁB
 *
 */

ret_int:
	mov.l	@_enadsp, er0		/* enadsp̃`FbN		*/
	beq	ret_int_1	/* fBXpb`֎~Ȃret_int_1	*/

	mov.l	@_runtsk, er0		/* er0 <- runtsk		*/
	mov.l	@_schedtsk, er1		/* er1 <- schedtsk		*/
	cmp.l	er0, er1		/* runtsk  schedtsk r	*/
	beq	ret_int_1		/* Ȃret_int_1		*/

        push.l  er5                     /* WX^ޔ */
        push.l  er6

	mov.l	sp, @(TCB_sp, e0)	/* ^XNX^bN|C^ۑ	*/
	mov.l	#ret_int_r, er1  	/* sĊJԒn			*/
	mov.l	er1, @(TCB_pc, er0)
	bra	dispatcher:16
		/*  8rbgPCΕł͓͂Ȃ߁A16rbgw  */

/*
 *  ݂̏oŃfBXpb`炱ɖ߂Ă
 */
ret_int_r:
        pop.l   er6                     /* WX^ */
        pop.l   er5

        /*
         *@^XNXCb`Ȃꍇ͂獇
         */
ret_int_1:
					/*  ^XNOԂ̃`FbN */
	mov.l	@_runtsk, er0
	mov.b	@(TCB_enatex, er0), r1l
	btst	#TCB_enatex_bit, r1l	/*  TCB.enatex=0 -> CCR.Z=1  */
	beq	ret_int_2	/*  ^XNO֎~ԂȂWv  */
	
					/*  ^XNOṽ`FbN */
	mov.l	@(TCB_texptn, er0), er1
	beq	ret_int_2	/*  ^XNOvȂ΃Wv */
	jsr	@_call_texrtn		/* ^XNO[`N	*/

ret_int_2:
        /* CPUbNtONA */
        sub.l   er0, er0
        mov.l   er0, @_iscpulocked

#ifdef SUPPORT_CHG_IPM
        /*
         *  X^bNɐςłccri߂̊݃}XNj
         *@task_intmaskɂBiLQƁj
         */
        mov.b   @(OFFSET_CCR, sp), r0l
        mov.b   @_task_intmask, r1l
        and.b   #H8INT_ENA_ALL, r0l
        or.b    r1l, r0l
        mov.b   r0l, @(OFFSET_CCR, sp)
#endif 	/* SUPPORT_CHG_IPM */
                                        /* WX^𕜌 */
        pop.l   er4                     /* @ +0:er4 */
        pop.l   er3                     /* @ +4:er3 */
        pop.l   er2                     /* @ +8:er2 */
        pop.l   er1                     /* @+12:er1 */
        pop.l   er0                     /* @+16:er0 */
                                        /*   +20:ccr  */
        rte


/*
 *  ^XNN
 */

	.globl _activate_r
_activate_r:
        /* CPUbNtONA */
        sub.l   er0, er0
        mov.l   er0, @_iscpulocked

	/*  ݋  */
#ifdef SUPPORT_CHG_IPM
        mov.b   @_task_intmask, r0l
        ldc.b   r0l, ccr
#else 	/* SUPPORT_CHG_IPM */
        ENAINT
#endif 	/* SUPPORT_CHG_IPM */

	mov.l	#_ext_tsk, er2
	push.l	er2
	mov.l	@_runtsk, er2
	mov.l	@(TCB_tinib, er2), er2
	mov.l	@(TINIB_task, er2), er1	/*  ^XNNԒn		*/
					/*  gi^XNւ̈j	*/
	mov.l	@(TINIB_exinf, er2), er0
	jmp	@er1


/**************************************************************
 *  ȉAʕƂ̃C^[tF[Xɂ͊܂܂ȂƎ̕
 **************************************************************/

/*
 *  no_reg_exception()
 *  CPUOƂēo^ĂȂOƌĂяoB
 *  O_PC,ER0`7o͂ăJ[l
 *  ~B
 * 
 * @X^bN\
 *@@ +0:er0
 *@@ +4:er1
 *@@ +8:er2
 *@@+12:er3
 *@@+16:er4
 *@@+20:er5
 *@@+24:er6
 *@@+28:crr
 *@@+29:pc
 *@@+32`:ݑOɎgpĂX^bN̈
 */
	.globl _no_reg_exception
_no_reg_exception:

	push.l	er6		/*  ER0`6ۑ			*/
	push.l	er5
	push.l	er4
	push.l	er3
	push.l	er2
	push.l	er1
	push.l	er0

	mov.l	sp, er0		/*  ݒ				*/
				/*  SP  +32 ŁA_̒l		*/
	jsr	@_cpu_experr	/*  cpu_experr()̌Ăяo		*/

