/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  Copyright (C) 2005-2007 by Y.D.K.Co.,LTD Technologies company
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: sys_support.S,v 1.1 2008/06/17 00:04:45 suikan Exp $
 */

#define _MACRO_ONLY
#include "jsp_kernel.h"
#include <ns9360.h>

/* vZbT[h */
Mode_SVC    =   0x13

/* Xe[^XWX^荞bit */
I_Bit       =   0x80
F_Bit       =   0x40

/*  BBUS reset register */
BBUS_RESET_BASE     = 0x90600000


/*
 *  ჌x̃^[QbgVXeˑ̏
 *
 *  X^[gAbvW[̒ŁC̑OɌĂяoD          
 */       

        .text
        .align 2
        .global hardware_init_hook
hardware_init_hook: 

/*
 * NS9360ˑ̏
 */
/*
 * bbus_reset
 */
        mov     r0, #0x0
        ldr     r0, =BBUS_RESET_BASE
        mov     r1, #0x0
        str     r1, [r0, #0]

/*
 * CSAGPIO Initial
 */
        stmfd sp!, {r4 - r11,lr}   /* WX^̕ۑ */
        bl      cpu_CsGpioInit
        ldmfd sp!,{r4 - r11,lr}

/*----*/
init_done:
        mov     pc, lr


/*
 *
 *  ݂̏o
 *         
 */        
        .text
        .align 4    
        .global IRQ_Handler
IRQ_Handler:

        /* 
         * ݃[h 
         * 
         * cpsrspsr_irqɕA悪r14_irq(lp)ɓC
         * spsr_irqr14_irqr13(sp)_irq r14,r13ƂȂD
         */

        /* 
         *  ^XN̓쎞[h(X[p[oCU[[h)
         */
        mov     sp,#(CPSR_SVC | CPSR_FIQ_BIT | CPSR_IRQ_BIT) 
        msr     cpsr_all, sp
        stmfd   sp!, {r0-r3,ip,lr,pc} /* pc̓_~[ */


        /*
         * spsrƖ߂Ԓn擾邽߂IRQ[h
         */
        mov     r0,#(CPSR_IRQ | CPSR_FIQ_BIT | CPSR_IRQ_BIT)
        msr     cpsr,r0
        sub     r0,lr,#4
        mrs     r1,spsr
        

        /*
         *  X[p[oCU[[h
         */ 
        and     r2,  r1, #CPSR_FIQ_BIT /* FIQrbǧp */
        orr     r2,  r2, #(CPSR_SVC|CPSR_IRQ_BIT)
        msr     cpsr, r2
        str     r0, [sp,#0x18] /* Store pc */
        stmfd   sp!,{r1}       /* spsr */


        /*
         *  d荞݂
         */
        ldr     r2, =interrupt_count
        ldr     r3, [r2]
        add     r0,r3,#1
        str     r0, [r2]
        cmp     r3, #0x00

        moveq   r2,sp            /* lXg荞݂łȂꍇ */
        ldreq   sp,=STACKTOP     /* X^bN̕ύX    */
        stmeqfd sp!,{r2}         /* ^XNX^bN̕ۑ */

        /*
         *  荞ݗv̔D
         *  INT_ID̓ǂݍ݁D(ɂKv͂ȂD)
         */

        ldr     r3, =ISRADDR_REG
        ldr     r0, [r3]        /* 荞݃xN^̓ǂݏo */

        /*
         *  `݂̊`FbN
         */
        cmp     r0, #0x00
        beq     undefined_interrupt
        
        /* 
         * 荞݋ 
         */
        mrs     r2, cpsr
        and     r2,  r2, #~CPSR_IRQ_BIT /* ݋ */
        msr     cpsr,r2

        /* 
         * Call Handler  
         */        
        mov     lr,  pc   
        mov     pc,  r0

        /* 
         * 荞݋֎~ 
         */
        mrs     r2, cpsr
        and     r2,  r2, #CPSR_FIQ_BIT /* FIQrbǧp */         
        orr     r2,  r2, #(CPSR_SVC|CPSR_IRQ_BIT)
        msr     cpsr,r2

        /* 
         * ݃lXg(interrupt_count) fNg 
         */
        ldr     r2, =interrupt_count
        ldr     r1, [r2]        
        sub     r3, r1, #1                        
        str     r3, [r2]
        cmp     r3, #0x00        
        bne     return_to_task_irq
        
        /*
         * ݃lXĝŁASẴ}XNNA
         */
        ldr     r2,  =ISRADDR_REG
        str     r0,  [r2]       /* ݃}XNNA */
        /* 
         * ^XNX^bN̕A 
         */
        ldmfd   sp!,{r0}         
        mov     sp, r0        
                
        ldr     r1, =reqflg    /* Check reqflg */
        ldr     r0, [r1]
        cmp     r0, #0
        beq     return_to_task_irq
        mov     r0, #0
        str     r0, [r1]       /* Clear reqflg */
        b       ret_int

return_to_task_irq:
        /*
         *  A
         *  荞݋ƂȂ邪^XNReLXgɕۑĂ邽߁C
         *  ͂Ȃ
         */
        ldmfd   sp!,{r1}           /* CPSR̕A */
        mrs     r2, cpsr           /* FIQp            */
        and     r2, r2, #CPSR_FIQ_BIT
        and     r1, r1, #~CPSR_FIQ_BIT
        orr     r1, r1, r2            
        msr     spsr, r1           
        ldmfd   sp!,{r0-r3,ip,lr,pc}^ /*^XNA + ݋ */

        /*
         *  `݂̊ƂɌĂяo
         */    
undefined_interrupt:
         b      undef_interrupt
    

/*
 * LbV֌W
 * UW       cpuEnableICache( void );
 * UW       cpuEnableDCache( void );
 * UW       cpuEnableMMU( UW tlbaddr );
 * UW       cpuDCache_Line_Invalid( UW mva );
 * UW       cpuDCache_Line_Flush( UW mva );
 * UW       cpuDCache_Line_FlushInalid( UW mva );
 * UW       cpuDCache_DrainWriteBuffer( void );
 */


        .global cpuEnableICache, cpuEnableDCache
        .global cpuEnableMMU
        .global cpuDCache_Line_Invalid, cpuDCache_Line_Flush
        .global cpuDCache_Line_FlushInvalid, cpuDCache_DrainWriteBuffer


#define CP15_ICACHE     0x1000
#define CP15_DCACHE     0x0004
#define CP15_MMU        0x0001


/*
 * CP15-R1I-cache bit(b12)=1 ɂB
 * Ȃ
 */
cpuEnableICache:
        mcr     p15, 0, r0, c7, c5, 0       /* ICache invalidate                */
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        mrc     p15, 0, r0, c1, c0, 0       /* CP15 R1                          */
        orr     r0, r0, #CP15_ICACHE        /* I-Cache enable                   */
        mcr     p15, 0, r0, c1, c0, 0       /* Set CP15 R1 I-cache              */
        mov     pc, lr


/*
 * CP15-R7Dcache invalidate {CP15-R1D-cache bit(b2)=1ɂB
 * ȂB
 */
cpuEnableDCache:
        mcr     p15, 0, r0, c7, c6, 0       /* DC all invalidate                */
        mrc     p15, 0, r0, c1, c0, 0       /* CP15 R1                          */
        orr     r0, r0, #CP15_DCACHE        /* D-Cache enable                   */
        mcr     p15, 0, r0, c1, c0, 0       /* Set CP15 R1 D-cache              */
        mov     pc,lr


/*
 * CP15-R1MMU bit(bit0)=1ɂBTLBݒTBLAhXɃR[B
 * r0:TLB address
 */
cpuEnableMMU:
        mcr     p15, 0, r0, c2, c0, 0       /* Set CP15 R2 TLB pointer          */
        mov     r0, #0                      /*                                  */
        mvn     r0, r0                      /* all domain is manager            */
        mcr     p15, 0, r0, c3, c0, 0       /* set Domain access (CP15 R3)      */

        mrc     p15, 0, r0, c1, c0, 0       /* CP15 R1                          */
        orr     r0, r0, #CP15_MMU           /* MMU enable                       */
        mcr     p15, 0, r0, c1, c0, 0       /* Set CP15 R1 MMU enable           */
        mov     pc,lr


/*
 * CP15-R7Invalidate DCache single entry(MVA)sB
 * r0:MVA
 */
cpuDCache_Line_Invalid:
        mcr     p15, 0, r0, c7, c6, 1       /* DC invalidate single entry(MVA)  */
        mov     pc,lr


/*
 * CP15-R7Clean DCache single entry(MVA)sB
 * r0:MVA
 */
cpuDCache_Line_Flush:
        mcr     p15, 0, r0, c7, c10, 1      /* DC clean single entry(MVA)       */
        mov     pc,lr


/*
 * CP15-R7Clean & Invalidate DCache single entry(MVA)sB
 * r0:MVA
 */
cpuDCache_Line_FlushInvalid:
        mcr     p15, 0, r0, c7, c14, 1      /* DC clean single entry(MVA)       */
        mov     pc,lr


/*
 * CP15-R7Drain write buffersB
 */
cpuDCache_DrainWriteBuffer:
        mcr     p15, 0, r0, c7, c10, 4      /* Drain write buffer               */
        mov     pc,lr

