﻿using System;

using Vintagestory.API.Server;
using Vintagestory.API.Common;



namespace AdminToolkit
{
	public abstract class AdminModCommand : ServerChatCommand
	{
		protected ICoreServerAPI ServerAPI;
		protected ILogger Logger;


		protected AdminModCommand(ICoreServerAPI _serverAPI) 
		{
			ServerAPI = _serverAPI;
			Logger = ServerAPI.World.Logger;
		}

		private AdminModCommand( )
		{
			throw new NotSupportedException( );
		}

		/// <summary>
		/// Gets or sets the cached configuration.
		/// </summary>
		/// <value>The cached configuration.</value>
		internal AdminModConfig CachedConfiguration {
			get {
				return ( AdminModConfig )ServerAPI.ObjectCache[AdminToolkit._configFilename];
			}
		}
	}
}

