﻿using System;

using System.Linq;
using System.Text;

using Vintagestory.API.Common;
using Vintagestory.API.Server;
using Vintagestory.Server;

namespace AdminToolkit
{
	public class PingerCommand : AdminModCommand
	{
		public PingerCommand(ICoreServerAPI _serverAPI) : base(_serverAPI)
		{


		this.Command = "pings";
		this.Description = "Display network Latency, per player(s)";
		this.Syntax = " (none) | all ";
		this.RequiredPrivilege = Privilege.chat;
		this.handler += HandlePingerCommand;

		}

		private void HandlePingerCommand(IServerPlayer player, int groupId, CmdArgs args)
		{
		var command = args.PopWord(string.Empty);

		switch (command) {
		case "all":
			AllPlayerPings(groupId, player);
			break;

		default:
			OwnPlayerPing(groupId, player);
			break;
		}
		}

		private void OwnPlayerPing(int groupId, IServerPlayer player)
		{
		player.SendMessage(groupId, $"{player.PlayerName}\t:\t{player.Ping:F3}S\n", EnumChatType.CommandSuccess);
		}

		private void AllPlayerPings(int groupId, IServerPlayer player)
		{
		StringBuilder pingsList = new StringBuilder( );
		
		foreach (var srvPlayer in ServerAPI.Server.Players.Where(plr => plr.ConnectionState == EnumClientState.Playing)) {
		pingsList.Append($"{srvPlayer.PlayerName}\t:\t{srvPlayer.Ping:F3}S\n");
		}
		player.SendMessage(groupId, pingsList.ToString( ), EnumChatType.CommandSuccess);
		}
	}

}