# Check for CLI compilers.                                  -*- Autoconf -*-

# Copyright (C) 2007  Free Software Foundation, Inc.
#
# This file is free software; the Free Software Foundation
# gives unlimited permission to copy and/or distribute it,
# with or without modifications, as long as this notice is preserved.

# AM_PROG_CLI([FRAMEWORK-VERSION],[LANGS])
# ----------------------------------------
# Find the compiler for each of the listed languages.  If LANGS is not set,
# it defaults to the list [CS].  The framework version determines if we
# use 'mcs' for version 1.1 or 'gmcs' for everything else.  We default to
# framework version 1.1.
AC_DEFUN([AM_PROG_CLI],
[_AM_PROG_CLI(m4_ifval([$1],[$1],[1.1]), m4_ifval([$2],[$2],[CS]))
AC_CHECK_PROGS([RESGEN], [resgen], [false])
AC_CHECK_PROGS([ILASM], [ilasm], [false])
AC_CHECK_PROGS([ILDISASM], [monodis 'ildasm -text'], [false])
])

AC_DEFUN([_AM_PROG_CLI],
[m4_foreach_w([l],[$2],[m4_n([_AM_PROG_CLI_LANG(l,[$1])])])])

AC_DEFUN([_AM_PROG_CLI_LANG],
[m4_ifdef([$0_$1],[$0_$1([$2])],[$0__FALLBACK([$1],[$2])])])

AC_DEFUN([_AM_PROG_CLI_LANG_CS],
[AC_CHECK_PROGS([CSC], [m4_if([$1],[1.1],[mcs],[gmcs]) csc], [false])])

AC_DEFUN([_AM_PROG_CLI_LANG_VB],
[AC_CHECK_PROGS([VBC], [vbnc vbc], [false])])

AC_DEFUN([_AM_PROG_CLI_LANG_NEMERLE],
[AC_CHECK_PROGS([NCC], [ncc], [false])])

AC_DEFUN([_AM_PROG_CLI_LANG__FALLBACK],
[AC_CHECK_PROGS([$1][C], [m4_translit([[$1]], [A-Z], [a-z])][c], [false])])

