#/bin/sh

. ./_cblfsset.sh

APPNAME=gnutls
VER=3.1.9.1
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$APPNAME-3.1.9

echo $TARGET

checkRequired \
	nettle
checkOptions  ""
checkTarball
checkExit "$1" || exit $?

cd $SRC

BIT32
RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Configuring...
export USE_ARCH=32 &&
CC="gcc ${BUILD32}" CXX="g++ ${BUILD32}" \
PKG_CONFIG_PATH="${PKG_CONFIG_PATH32}" \
./configure --prefix=/usr \
	1> $LOG/$TARGET.$BIT.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$TARGET.$BIT.2_make.log 2>&1 || exit 1

echo Installing...
paco -p $TARGET "\
make install" \
	1> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
unset USE_ARCH

TimeEnd
cd ..

BIT64
RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Configuring...
export USE_ARCH=64 &&
CC="gcc ${BUILD64}" CXX="g++ ${BUILD64}" \
PKG_CONFIG_PATH="${PKG_CONFIG_PATH64}" \
./configure --prefix=/usr --libdir=/usr/lib64 \
        1> $LOG/$TARGET.$BIT.1_conf.log 2>&1 || exit 1

echo Making...
make \
        1> $LOG/$TARGET.$BIT.2_make.log 2>&1 || exit 1

echo Installing...
paco -p+ $TARGET "\
make install" \
        1> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
unset USE_ARCH

TimeEnd
cd ..
RemoveSrcDir
PacoingDone

