//
//  KCCollectionWindowController.m
//  KanColleLevelManager
//
//  Created by Hori,Masaki on 2013/10/16.
//  Copyright (c) 2013年 Hori,Masaki. All rights reserved.
//

#import "KCCollectionWindowController.h"

#import "HMAppDelegate.h"
#import "CollectedShip.h"

@interface KCCollectionWindowController ()

@end

@implementation KCCollectionWindowController

- (id)init
{
    self = [super initWithWindowNibName:NSStringFromClass([self class])];
    if (self) {
        // Initialization code here.
    }
    return self;
}

- (void)windowDidLoad
{
    [super windowDidLoad];
    
    // Implement this method to handle any initialization after your window controller's window has been loaded from its nib file.
	
	NSString *path = [[NSBundle mainBundle] pathForResource:@"shipFetchPredicate" ofType:@"plist"];
	NSArray *array = [NSArray arrayWithContentsOfFile:path];
	if(!array || [array count] != 2) {
		NSBeep();
		NSLog(@"Could not load shipFetchPredicate");
		[NSApp terminate:self];
		return;
	}
	
	id format = array[0] ;//[array objectAtIndex:0];
	id arguments = array[1]; //[array objectAtIndex:1];
	NSPredicate *fetchPredicate = [NSPredicate predicateWithFormat:format argumentArray:arguments];
	[self.shipController setFetchPredicate:fetchPredicate];
}
- (NSUndoManager *)windowWillReturnUndoManager:(NSWindow *)window
{
	return self.managedObjectContext.undoManager;
}

- (NSManagedObjectContext *)managedObjectContext
{
	return ((HMAppDelegate *)[NSApp delegate]).managedObjectContext;
}


- (IBAction)addShip:(id)sender
{
	id selection = [self.shipController selectedObjects];
	if(!selection || [selection count] == 0) {
		NSLog(@"Empty selection");
		return;
	}
	
	for(id ship in selection) {
		
		CollectedShip *newShip = [NSEntityDescription insertNewObjectForEntityForName:@"CollectedShip"
															   inManagedObjectContext:self.managedObjectContext];
		if(!newShip) {
			NSLog(@"Could not insert new CollectedShip");
			return;
		}
		
		newShip.ship = ship;
		
		NSMutableSet *set = [ship mutableSetValueForKey:@"collection"];
		[set addObject:newShip];
	}
	
	[self.managedObjectContext commitEditing];
	
}

- (IBAction)removeCollection:(id)sender
{
	NSAlert *alert = [NSAlert alertWithMessageText:@"realy?"
									 defaultButton:@"Cancel"
								   alternateButton:@"OK"
									   otherButton:nil
						 informativeTextWithFormat:@"Realey???"];
	[alert beginSheetModalForWindow:self.window
					  modalDelegate:self
					 didEndSelector:@selector(hoge:::)
						contextInfo:NULL];
}
- (void)hoge:(id)hoge :(NSInteger)foo :(void *)bar
{
	if(foo == NSAlertDefaultReturn) return;
	
//	[self.collectionController remove:self];
	[self.collectionController removeObjects:[self.collectionController selectedObjects]];
}


@end
