//
//  KCFleetWindowController.m
//  KanColleLevelManager
//
//  Created by Hori,Masaki on 2013/10/18.
//  Copyright (c) 2013年 Hori,Masaki. All rights reserved.
//

#import "KCFleetWindowController.h"

#import "HMAppDelegate.h"
#import "CollectedShip.h"

#import "KCShipViewController.h"

#import "KCFleetViewController.h"


@interface KCFleetWindowController ()
@property (nonatomic, retain) KCFleetViewController *fleetViewController;

@property (retain) NSDictionary *categoryList;

@end

@implementation KCFleetWindowController

- (id)init
{
    self = [super initWithWindowNibName:NSStringFromClass([self class])];
    if (self) {
        // Initialization code here.
		
		NSString *path = [[NSBundle mainBundle] pathForResource:@"Category" ofType:@"plist"];
		_categoryList = [NSDictionary dictionaryWithContentsOfFile:path];
		
	}
    return self;
}

- (void)windowDidLoad
{
    [super windowDidLoad];
	
	self.fleetViewController = [KCFleetViewController new];
	NSView *view = self.fleetViewController.view;
	view.frame = self.fleetPlaceholder.frame;
	[[self.fleetPlaceholder superview] replaceSubview:self.fleetPlaceholder with:view];
	
	[self bind:@"fleetNumber"
						  toObject:self.fleetViewController
					   withKeyPath:@"fleetNumber"
						   options:nil];
	
	self.fleetNumber = @1;
	
	
	NSFetchRequest *req = [NSFetchRequest fetchRequestWithEntityName:@"ShipType"];
	NSSortDescriptor *sortDesc = [NSSortDescriptor sortDescriptorWithKey:@"name" ascending:YES];
	[req setSortDescriptors:@[sortDesc]];
	NSArray *types = [self.managedObjectContext executeFetchRequest:req
															  error:NULL];
	
	[self.typePopUp removeAllItems];
	[self.typePopUp addItemWithTitle:@"All"];
	for(id type in types) {
		[self.typePopUp addItemWithTitle:[type valueForKey:@"name"]];
	}
	[self.typePopUp sizeToFit];
}
- (NSUndoManager *)windowWillReturnUndoManager:(NSWindow *)window
{
	return self.managedObjectContext.undoManager;
}

- (NSManagedObjectContext *)managedObjectContext
{
	return ((HMAppDelegate *)[NSApp delegate]).managedObjectContext;
}

- (CollectedShip *)shipForFleetNumber:(NSNumber *)fleetNumber fleetOrder:(NSNumber *)fleetOrder
{
	if(!fleetNumber || !fleetOrder) return nil;
	
	NSPredicate *predicate = [NSPredicate predicateWithFormat:@"fleetNumber = %@ AND fleetOrder = %@", fleetNumber, fleetOrder];
	NSFetchRequest *req = [NSFetchRequest fetchRequestWithEntityName:@"CollectedShip"];
	[req setPredicate:predicate];
	NSArray *fleetShips = [self.managedObjectContext executeFetchRequest:req
																   error:NULL];
	if(!fleetShips || [fleetShips count] == 0) return nil;
	
	return [fleetShips lastObject];
}
- (NSArray *)shipsForFleetNumber:(NSNumber *)fleetNumber
{
	if(!fleetNumber) return nil;
	
	NSPredicate *predicate = [NSPredicate predicateWithFormat:@"fleetNumber = %@", fleetNumber];
	NSFetchRequest *req = [NSFetchRequest fetchRequestWithEntityName:@"CollectedShip"];
	[req setPredicate:predicate];
	NSArray *fleetShips = [self.managedObjectContext executeFetchRequest:req
																   error:NULL];
	
	return fleetShips;
}

- (void)packFleetNumber:(NSNumber *)fleetNumber
{
	if(!fleetNumber) return;
	
	NSPredicate *predicate = [self predicateWithFleetNumber:fleetNumber];
	NSSortDescriptor *sortDesc = [NSSortDescriptor sortDescriptorWithKey:@"fleetOrder"
															   ascending:YES];
	NSFetchRequest *req = [NSFetchRequest fetchRequestWithEntityName:@"CollectedShip"];
	[req setPredicate:predicate];
	[req setSortDescriptors:@[sortDesc]];
	NSArray *fleetShips = [self.managedObjectContext executeFetchRequest:req
																   error:NULL];
	NSInteger order = 1;
	for(CollectedShip *ship in fleetShips) {
		NSInteger shipOrder = [ship.fleetOrder integerValue];
		if(shipOrder != order) {
			ship.fleetOrder = @(order);
		}
		order++;
	}
}

- (NSPredicate *)predicateWithFleetNumber:(NSNumber *)fleetNumber
{
	return [NSPredicate predicateWithFormat:@"fleetNumber = %@", fleetNumber];
}

- (IBAction)addToFleet:(id)sender
{
	CollectedShip *selection = [[self.collectionShip selectedObjects] lastObject];
	
	NSInteger tag = [sender tag];
	if(tag != 1) {
		CollectedShip *prev = [self shipForFleetNumber:self.fleetNumber fleetOrder:@(tag - 1)];
		
		if(!prev) {
			NSBeep();
			return;
		}
	}
	
	CollectedShip *ship = [self shipForFleetNumber:self.fleetNumber fleetOrder:@(tag)];
	do {
		if(ship && [ship.fleetNumber isEqual:self.fleetNumber]) break;
		
		if([selection.fleetNumber isEqual:self.fleetNumber]) {
			NSInteger currentOrder = [selection.fleetOrder integerValue];
			if(currentOrder <= tag) {
				NSBeep();
				return;
			}
		}
	} while(NO);
	
	ship.fleetNumber = selection.fleetNumber;
	ship.fleetOrder = selection.fleetOrder;
	
	NSNumber *selectionFleetNumber = selection.fleetNumber;
	selection.fleetNumber = self.fleetNumber;
	selection.fleetOrder = @(tag);
	[self packFleetNumber:selectionFleetNumber];
	
	[self.fleetViewController update];
}
- (IBAction)removeFromFleet:(id)sender
{
	NSInteger tag = [sender tag];
	CollectedShip *ship = [self shipForFleetNumber:self.fleetNumber fleetOrder:@(tag)];
	ship.fleetNumber = nil;
	ship.fleetOrder = nil;
	[self packFleetNumber:self.fleetNumber];
	
	[self.fleetViewController update];
}


- (IBAction)selectType:(id)sender
{
	NSPredicate *predicate = nil;
	NSString *title = [[self.typePopUp selectedItem] title];
	if(![@"All" isEqualToString:title]) {
		predicate = [NSPredicate predicateWithFormat:@"ship.type.name = %@", [[sender selectedItem] title]];
	}
	[self.collectionShip setFetchPredicate:predicate];
}

- (IBAction)selectCategory:(id)sender
{
	NSPredicate *predicate = nil;
	NSInteger segment = [sender selectedSegment];
	NSString *label = [sender labelForSegment:segment];
	
	NSDictionary *types = [self.categoryList objectForKey:label];
	if(types) {
		predicate = [NSPredicate predicateWithFormat:@"ship.type.name IN %@", types];
	}
	
	[self.collectionShip setFetchPredicate:predicate];
	
}


@end
