//
//  KCStatusCheckWindowController.m
//  KanColleLevelManager
//
//  Created by Hori,Masaki on 2014/02/02.
//  Copyright (c) 2014年 Hori,Masaki. All rights reserved.
//

#import "KCStatusCheckWindowController.h"

#import "HMAppDelegate.h"


@interface KCStatusCheckWindowController ()


@property (retain) NSDictionary *categoryList;

@property (readonly) BOOL hideMaxFire;
@property (readonly) BOOL hideMaxTorpedo;
@property (readonly) BOOL hideMaxAA;
@property (readonly) BOOL hideMaxArmor;
@property (readonly) BOOL hideMaxLuck;

@end

@implementation KCStatusCheckWindowController

@dynamic hideMaxFire, hideMaxTorpedo, hideMaxAA, hideMaxArmor, hideMaxLuck;

- (id)init
{
    self = [super initWithWindowNibName:NSStringFromClass([self class])];
    if (self) {
        // Initialization code here.
		
		NSString *path = [[NSBundle mainBundle] pathForResource:@"Category" ofType:@"plist"];
		_categoryList = [NSDictionary dictionaryWithContentsOfFile:path];
		
	}
    return self;
}

- (NSUndoManager *)windowWillReturnUndoManager:(NSWindow *)window
{
	return self.managedObjectContext.undoManager;
}

- (NSManagedObjectContext *)managedObjectContext
{
	return ((HMAppDelegate *)[NSApp delegate]).managedObjectContext;
}

- (id)valueForUndefinedKey:(NSString *)key
{
	NSArray *defindeKyes = @[@"hideMaxFire", @"hideMaxTorpedo", @"hideMaxAA", @"hideMaxArmor", @"hideMaxLuck"];
	if([defindeKyes containsObject:key]) {
		return [[NSUserDefaults standardUserDefaults] objectForKey:key];
	}
	
	return [super valueForUndefinedKey:key];
}
- (BOOL)hideMaxFire
{
	return [[NSUserDefaults standardUserDefaults] boolForKey:@"hideMaxFire"];
}
- (BOOL)hideMaxTorpedo
{
	return [[NSUserDefaults standardUserDefaults] boolForKey:@"hideMaxTorpedo"];
}
- (BOOL)hideMaxAA
{
	return [[NSUserDefaults standardUserDefaults] boolForKey:@"hideMaxAA"];
}
- (BOOL)hideMaxArmor
{
	return [[NSUserDefaults standardUserDefaults] boolForKey:@"hideMaxArmor"];
}
- (BOOL)hideMaxLuck
{
	return [[NSUserDefaults standardUserDefaults] boolForKey:@"hideMaxLuck"];
}

- (NSPredicate *)omitPredicate
{
	NSMutableArray *hideKeys = [NSMutableArray array];
	if(self.hideMaxFire) {
		[hideKeys addObject:@"isMaxFire != TRUE"];
	}
	if(self.hideMaxTorpedo) {
		[hideKeys addObject:@"isMaxTorpedo != TRUE"];
	}
	if(self.hideMaxAA) {
		[hideKeys addObject:@"isMaxAA != TRUE"];
	}
	if(self.hideMaxArmor) {
		[hideKeys addObject:@"isMaxArmor != TRUE"];
	}
	if(self.hideMaxLuck) {
		[hideKeys addObject:@"isMaxLuck != TRUE"];
	}
	
	if([hideKeys count] == 0) return nil;
	
	NSString *predicateString = [hideKeys componentsJoinedByString:@" AND "];
	
	return [NSPredicate predicateWithFormat:predicateString];
}

- (IBAction)selectCategory:(id)sender
{
	NSPredicate *predicate = [self omitPredicate];
	NSInteger segment = [self.typeSegment selectedSegment];
	NSString *label = [self.typeSegment labelForSegment:segment];
	
	NSDictionary *types = [self.categoryList objectForKey:label];
	if(types) {
		NSPredicate *catPredicate = [NSPredicate predicateWithFormat:@"ship.type.name IN %@", types];
		if(predicate) {
			NSArray *sub = @[predicate, catPredicate];
			predicate = [NSCompoundPredicate andPredicateWithSubpredicates:sub];
		} else {
			predicate = catPredicate;
		}
	}

	
	[self.collectionShip setFetchPredicate:predicate];
}

@end
