//
//  KCShipViewController.m
//  KanColleLevelManager
//
//  Created by Hori,Masaki on 2013/10/22.
//  Copyright (c) 2013年 Hori,Masaki. All rights reserved.
//

#import "KCShipViewController.h"

#import "HMAppDelegate.h"
#import "CollectedShip.h"

@interface KCShipViewController ()

@end

@implementation KCShipViewController

- (id)init
{
    self = [super initWithNibName:NSStringFromClass([self class]) bundle:nil];
    if (self) {
        // Initialization code here.
    }
    return self;
}

+ (NSSet *)keyPathsForValuesAffectingCanUpdate
{
	return [NSSet setWithObjects:@"ship", @"ship.level", @"ship.ship", nil];
}


- (NSManagedObjectContext *)managedObjectContext
{
	return ((HMAppDelegate *)[NSApp delegate]).managedObjectContext;
}

- (void)setRepresentedObject:(id)representedObject
{
	self.ship = representedObject;
	[super setRepresentedObject:representedObject];
}

- (BOOL)canUpdate
{
	NSNumber *shipLevel = self.ship.level;
	NSNumber *updateLevel = [self.ship.ship valueForKey:@"updateLevel"];
	if(!updateLevel) return NO;
	if(NSOrderedAscending == [shipLevel compare:updateLevel]) {
		return NO;
	}
	return YES;
}

- (IBAction)update:(id)sender
{
	NSNumber *targetNumber = [self.ship.ship valueForKey:@"updateNumber"];
	if(!targetNumber) return;
	
	NSFetchRequest *req = [NSFetchRequest fetchRequestWithEntityName:@"Ship"];
	NSPredicate *predicate = [NSPredicate predicateWithFormat:@"number == %@", targetNumber];
	[req setPredicate:predicate];
	NSArray *targetShps = [self.managedObjectContext executeFetchRequest:req
																   error:NULL];
	if(!targetShps || [targetShps count] == 0) {
		return;
	}
	self.ship.ship = targetShps[0];
	
	self.ship.isMaxFire = @NO;
	self.ship.isMaxTorpedo = @NO;
	self.ship.isMaxAA = @NO;
	self.ship.isMaxArmor = @NO;
	self.ship.isMaxLuck = @NO;
}

@end
