//
//  KCFleet.m
//  KanColleLevelManager
//
//  Created by Hori,Masaki on 2013/10/20.
//  Copyright (c) 2013年 Hori,Masaki. All rights reserved.
//

#import "KCFleet.h"


static NSArray *sFleet = nil;

@interface KCFleet ()
@property (readwrite) NSNumber *number;
@property (readwrite) NSNumber *order;

@end

@implementation KCFleet

+ (void)initialize
{
	static BOOL isFirst = YES;
	if(isFirst) {
		isFirst = NO;
		
		sFleet = [NSArray arrayWithObjects:
				  [NSMutableArray arrayWithCapacity:6],
				  [NSMutableArray arrayWithCapacity:6],
				  [NSMutableArray arrayWithCapacity:6],
				  [NSMutableArray arrayWithCapacity:6],
				  nil];
	}
}

+ (KCFleet *)fleetOfNumber:(NSNumber *)number order:(NSNumber *)order
{
	NSArray *array = [sFleet objectAtIndex:[number integerValue] - 1];
	if([array count] < [order integerValue] - 1) return nil;
	
	return [array objectAtIndex:[order integerValue] - 1];
}

- (BOOL)canInsertAtNumber:(NSNumber *)number order:(NSNumber *)order
{
	NSMutableArray *array = [sFleet objectAtIndex:[number integerValue] - 1];
	if([array count] < [order integerValue] - 1) return NO;
	
	return YES;
}

- (BOOL)setNumber:(NSNumber *)number order:(NSNumber *)order
{
	if(![self canInsertAtNumber:number order:order]) return NO;
	
	NSMutableArray *array = [sFleet objectAtIndex:[number integerValue] - 1];
	[array addObject:self];
	_number = number;
	_order = order;
	
	return YES;
}

- (KCFleet *)replaceNumber:(NSNumber *)number order:(NSNumber *)order
{
	if(![self canInsertAtNumber:number order:order]) return nil;
	
	NSMutableArray *array = [sFleet objectAtIndex:[number integerValue] - 1];
	id current = [array objectAtIndex:[order integerValue] - 1];
	[array replaceObjectAtIndex:[order integerValue] - 1 withObject:self];
	
	return current;
}

- (void)removeFromFleet
{
	self.number = nil;
	self.order = nil;
}

- (NSUInteger)hash
{
	return [self.number integerValue] + [self.order integerValue];
}
- (BOOL)isEqual:(id)object
{
	if(![object isKindOfClass:[self class]]) return NO;
	
	KCFleet *fleet = object;
	
	if(![self.number isEqual:fleet.number]) return NO;
	
	if(![self.order isEqual:fleet.order]) return NO;
	
	return YES;
}

- (id)description
{
	return [NSString stringWithFormat:@"%@ - %@", self.number, self.order];
}

@end
