//
//  KMStatusLineViewController.m
//  BathyScaphe
//
//  Created by 堀 昌樹 on 12/01/09.
//  Copyright (c) 2012年 __MyCompanyName__. All rights reserved.
//

#import "KMStatusLineViewController.h"

#import "CMRTaskManager.h"
#import "KMBSLogViewController.h"

@implementation KMStatusLineViewController
@synthesize indexingNavigator = _indexingNavigator;
@synthesize taskController = _taskController;
@synthesize windowController = _windowController;
@synthesize addBoardButton = _addBoardButton;
@synthesize messageField = _messageField;
@synthesize hasAddBoardButton = _hasAddBoardButton;
@synthesize leftAreaWidth = _leftAreaWidth;


const CGFloat messageLeftMergin = 5;
const CGFloat messageFieldAddButtonMergin = 43;

- (id)init
{
	self = [super initWithNibName:@"KMStatusLineViewController" bundle:nil];
	return self;
}
- (void)dealloc
{
	self.windowController = nil;
	[self.taskController unbind:@"contentObject"];
	
	[super dealloc];
}

- (void)loadView
{
	[super loadView];
	
	[self setLeftAreaWidth:0];
	[self.taskController bind:@"contentObject"
					 toObject:[CMRTaskManager defaultManager]
				  withKeyPath:@"currentTask"
					  options:nil];
}
- (void)validateIdxNavLazily:(KMBSLogViewController *)controller
{
    [[self indexingNavigator] setEnabled:[controller canScrollFirstMessage] forSegment:0];
    [[self indexingNavigator] setEnabled:[controller canScrollLastMessage] forSegment:4];
    [[self indexingNavigator] setEnabled:[controller canScrollPrevMessage] forSegment:1];
    [[self indexingNavigator] setEnabled:[controller canScrollNextMessage] forSegment:3];
    [[self indexingNavigator] setEnabled:[controller canScrollToLastUpdatedMessage] forSegment:2];
}
- (void)setLeftAreaWidth:(NSUInteger)leftAreaWidth
{
	if(_leftAreaWidth == leftAreaWidth) return;
	
	if(self.hasAddBoardButton && leftAreaWidth < messageFieldAddButtonMergin) {
		leftAreaWidth = messageFieldAddButtonMergin;
	}
	
	NSRect newFrame = [_messageField frame];
	CGFloat messageFieldLeft = newFrame.origin.x;
	newFrame.origin.x = leftAreaWidth + messageLeftMergin;
	newFrame.size.width += messageFieldLeft - leftAreaWidth;
	[_messageField setFrame:newFrame];
	
	_leftAreaWidth = leftAreaWidth;
}
- (NSUInteger)leftAreaWidth
{
	return _leftAreaWidth;
}
- (void)setHasAddBoardButton:(BOOL)hasAddBoardButton
{
	if(hasAddBoardButton) {
		if(self.leftAreaWidth < messageFieldAddButtonMergin) {
			self.leftAreaWidth = messageFieldAddButtonMergin;
		}
	} else {
		if(self.leftAreaWidth == messageFieldAddButtonMergin) {
			self.leftAreaWidth = 0;
		}
	}
	_hasAddBoardButton = hasAddBoardButton;
}
- (BOOL)hasAddBoardButton
{
	return _hasAddBoardButton;
}
@end
