//
//  KMDocument.h
//  BathyScaphe
//
//  Created by 堀 昌樹 on 11/12/08.
//  Copyright (c) 2011年 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import "CMRThreadMessage.h"

@class CMRThreadAttributes;
@class CMRThreadMessageBuffer;

#if !__LP64__
@class BSMessageSampleRegistrant;
#endif

@interface KMDocument : NSDocument
{
	CMRThreadAttributes *_threadAttr;
	
#if !__LP64__
	CMRThreadMessageBuffer *_messageBuffer;
	BOOL _messagesEdited;
	BSMessageSampleRegistrant *_registrant;
#endif
}
@property (retain) CMRThreadAttributes *threadAttr;
@property (readonly, retain) CMRThreadMessageBuffer *messageBuffer;	// DO NOT change buffer.
@property (readonly, getter = isMessagesEdited) BOOL messagesEdited;

@property (readonly) NSString *path;
@property (readonly) NSString *boardName;
@property (readonly) NSString *threadTitle;
@property (readonly) NSString *bbsIdentifier;
@property (readonly) NSString *datIdentifier;
@property (readonly) NSURL *boardURL;
@property (readonly) NSURL *threadURL;

@property (readonly) NSDictionary *threadDictionary;

@property (assign) NSUInteger lastViewingIndex;
@property (assign) NSRect savedWindowFrame;

- (void)setLabelValue:(NSUInteger)label;
@end

@interface KMDocument(Filters)
- (void)registerSpam:(CMRThreadMessage *)message;
- (void)unregisterSpam:(CMRThreadMessage *)message;

- (IBAction)runAsciiArtDetector:(id)sender;
- (IBAction)runSpamFilter:(id)sender;
@end

@interface KMDocument(Actions)
- (IBAction)reload:(id)sender;
- (IBAction)reloadThread:(id)sender; // same as reload:

- (IBAction)retrieve:(id)sender;

@end

@interface KMDocument(CMRThreadLayout_Methods)
- (NSArray *)messages;
- (CMRThreadMessage *)messageAtIndex:(NSUInteger)index;
- (NSArray *)messagesAtIndexes:(NSIndexSet *)indexes;
- (NSUInteger)numberOfReadedMessages;
- (NSUInteger)numberOfMessageAttributes:(UInt32)mask;


@end

extern NSString *KMDocumentDidChangeNotification;

extern NSString *KMDocumentDidChangeMessageNotification;
extern		NSString *KMDocumentChangedMessageIndexKey; // NSNumber
