#import "CircleGestureView.h"

@implementation CircleGestureView

- (id)initWithFrame:(NSRect)frameRect
{
	if ((self = [super initWithFrame:frameRect]) != nil) {
		// Add initialization code here
		prevPoint = NSZeroPoint;
	}
	return self;
}

- (void)awakeFromNib
{
	[[self window] setAcceptsMouseMovedEvents:YES];
}

- (void)setGestureTarget:(id)target
{
	gestureTarget = target;
}
- (id)gestureTarget
{
	return gestureTarget;
}
- (void)setGestureAction:(SEL)action
{
	gestureAction = action;
}
- (SEL)gestureAction
{
	return gestureAction;
}

- (BOOL)acceptsFirstResponder
{
	return YES;
}
- (void)mouseMoved:(NSEvent *)theEvent
{
	NSPoint mouse = [theEvent locationInWindow];
	
	float deltaV, deltaH;
	int quadrant;
	
	if([theEvent timestamp] - prevTime > 0.5) {
		phase = 0;
	}
	prevTime = [theEvent timestamp];
	
	deltaV = prevPoint.y - mouse.y;
	deltaH = prevPoint.x - mouse.x;
	
	//  象限チェック
	if( deltaV <= 0 && deltaH <= 0 ) {
		quadrant = secondQuadrant;
	} else if( deltaV <= 0 && deltaH >= 0) {
		quadrant = thirdQuadrant;
	} else if( deltaV >= 0 && deltaH <= 0 ) {
		quadrant = firstQuadrant;
	} else if( deltaV >= 0 && deltaH >= 0 ) {
		quadrant = fourthQuadrant;
	}
	
	switch( prevQuadrant - quadrant ) {
		case 0:
			//
			break;
		case 1:
		case -3:
			phase++;
#ifdef DEBUG
			NSLog(@"Phase %d.", phase);
#endif
			//
			break;
		default:
			phase = 0;
			break;
	}
	
	prevQuadrant = quadrant;
	
	if(phase == 6) {
		phase = 0;
#ifdef DEBUG
		NSLog(@"Gesture Action!!");
#endif
		[NSApp sendAction:gestureAction
					   to:gestureTarget
					 from:self];
	}
	
final:
	prevPoint = mouse;
}
- (void)mouseExited:(NSEvent *)theEvent
{
	prevQuadrant = nonQuadrant;
	prevPoint = NSZeroPoint;
	prevTime = 0;
}
@end
