//
//  ZBarScanner.m
//  Barcode Scanner
//
//  Created by Chris Karr on 1/20/10.
//  Copyright 2010 Audacious Software. All rights reserved.
//

#import "ZBarScanner.h"
#import <QuartzCore/QuartzCore.h>

//#define WIDTH_OF_IMAGE 320
//#define HEIGHT_OF_IMAGE 240

//#define widthOfImage 640
//#define heightOfImage 240


@interface ZBarScanner (Private)
@end


@implementation ZBarScanner

- (id)initWithDataBuffer:(unsigned char *)grayScale height:(NSInteger)heightOfImage width:(NSInteger)widthOfImage {
	self = [super init];
	if (self != nil) {
		unsigned long gray = zbar_fourcc('Y','8','0','0');
		zImage = zbar_image_create();
		zbar_image_set_size(zImage, widthOfImage, heightOfImage);
		zbar_image_set_format(zImage, gray);	
		zbar_image_set_data(zImage, grayScale, widthOfImage * heightOfImage, NULL);
		
		//zbar_set_verbosity(5);
		
		scanner = zbar_image_scanner_create();
		zbar_image_scanner_set_config(scanner, ZBAR_UPCA | ZBAR_ISBN10 | ZBAR_UPCA | ZBAR_EAN13 | ZBAR_ISBN13, 0, 0); // ZBAR_PARTIAL |
		//zbar_image_scanner_enable_cache(scanner, YES);
	}
	return self;
	
}


- (void) dealloc
{
	[previewView release];
	zbar_image_scanner_destroy(scanner); scanner = nil;
	zbar_image_destroy(zImage); zImage = nil;
	[super dealloc];
}
	

- (void)setPreviewView:(SampleCIView *)aView {
	[previewView release];
	previewView = [aView retain];
}


- (NSString *)scan {
	//NSLog(@"Scanning");

	//NSMutableDictionary * dict = [NSMutableDictionary dictionary];
	if (scanner && zImage) {
	int nsyms = zbar_scan_image(scanner, zImage);
	
	if (nsyms > 0)
	{
		//NSLog(@"GOT %d RESULTS", nsyms);
		//NSBeep();

		const zbar_symbol_set_t *set = zbar_image_scanner_get_results(scanner);

		const zbar_symbol_t *sym = zbar_symbol_set_first_symbol(set);

		//zbar_symbol_type_t t = zbar_symbol_get_type(sym);
		//const char *typeName = zbar_get_symbol_name(t);
		//[dict setValue:[NSString stringWithCString:typeName] forKey:@"type"];
		
		int confidence = zbar_symbol_get_quality(sym);

		if (confidence > 4) {
			const char * data = zbar_symbol_get_data(sym);
			return [NSString stringWithUTF8String:data];
		}
		else if (confidence > 0) {
			[previewView setGoodScan:YES]; 
			//NSLog(@"%d", confidence);
			//const char * data = zbar_symbol_get_data(sym);
			//NSLog(@"Code %@", [NSString stringWithUTF8String:data]); 

		}
		//[dict setValue:[NSString stringWithCString:data] forKey:@"code"];
		

		//[dict setValue:[NSNumber numberWithInt:confidence] forKey:@"confidence"];
		
		/*
		NSMutableArray * polygon = [NSMutableArray array];
		unsigned i;
		for (i = 0; i < zbar_symbol_get_loc_size(sym); i++)
		{
			NSPoint p;
			p.x = zbar_symbol_get_loc_x(sym, i);
			p.y = zbar_symbol_get_loc_y(sym, i);

			[polygon addObject:[NSValue valueWithPoint:p]];
		}

		[dict setValue:polygon forKey:@"area"];
		 */
	}
	}
	
	return nil;
}

/*
#pragma mark -


static CGImageRef CreateCGImageFromPixelBuffer(CVImageBufferRef inImage, OSType inPixelFormat)
{
    CGDataProviderRef provider = NULL;
    CGColorSpaceRef colorSpace = NULL;
    CGImageRef image = NULL;
    void *baseAddress;
    size_t bytesPerRow, width, height;
    size_t bitsPerComponent, bitsPerPixel;
    CGImageAlphaInfo alphaInfo;
    
    if (NULL == inImage || 0 == inPixelFormat) return NULL;
	CVReturn possibleError = CVPixelBufferLockBaseAddress(inImage, 0);
	if (possibleError) {
		DLog(@"Error locking pixel bufffer, when looking for barcode.");
		return nil;
	}
	
    baseAddress = CVPixelBufferGetBaseAddress(inImage);
    bytesPerRow = CVPixelBufferGetBytesPerRow(inImage);
    width = CVPixelBufferGetWidth(inImage);
    height = CVPixelBufferGetHeight(inImage);
    
    switch(inPixelFormat) {
			// in this app we're only dealing with 32 ARGB pixel buffers
			// see the Quartz 2D Programming Guide for a list of supported formats
		case k32ARGBPixelFormat:
			bitsPerComponent = 8;
			bitsPerPixel = 32;
			alphaInfo = kCGImageAlphaFirst;
			
			break;
		default:
			printf("I don't know what to do with this format!\n");
			goto Bail;
			
			break;
    }
    
    // Colorspace can be device, calibrated, or ICC profile based.
    colorSpace = CGColorSpaceCreateWithName(kCGColorSpaceGenericRGB);
    require(NULL != colorSpace, Bail);
	
    // Draw some text on the image just for something to do
    //DrawOnImage(baseAddress, bytesPerRow, width, height, colorSpace);
    
    // Create a data provider with a pointer to the memory bits
    provider = CGDataProviderCreateWithData(NULL, baseAddress, bytesPerRow * height, NULL);
    require(NULL != provider, Bail);
	
    // Create the image
    image = CGImageCreate(width, height, bitsPerComponent, bitsPerPixel, bytesPerRow, colorSpace, alphaInfo, provider, NULL, false, kCGRenderingIntentDefault);
	
Bail:
    // Once the image is created we can release our reference to the provider and the colorspace, they are retained by the image
    if (NULL != provider) CGDataProviderRelease(provider);
    if (NULL != colorSpace) CGColorSpaceRelease(colorSpace);
	CVPixelBufferUnlockBaseAddress(inImage, 0);
	
	
    return image;
}
*/


/*
 CGImageRef theCGImage = CreateCGImageFromPixelBuffer(buffer, k32ARGBPixelFormat);
 
 unsigned int w = CGImageGetWidth(theCGImage) + 0.5;
 unsigned int h = CGImageGetHeight(theCGImage) + 0.5;
 
 unsigned long datalen = w * h;
 uint8_t *raw = malloc(datalen);
 // FIXME handle OOM
 assert(raw);
 zbar_image_t * zImage = zbar_image_create();
 zbar_image_set_data(zImage, raw, datalen, NULL);
 zbar_image_set_format(zImage, zbar_fourcc('Y','8','0','0'));
 zbar_image_set_size(zImage, w, h);
 
 // generate grayscale image data
 CGColorSpaceRef cs = CGColorSpaceCreateDeviceGray();
 CGContextRef ctx =
 CGBitmapContextCreate(raw, w, h, 8, w, cs, kCGImageAlphaNone);
 CGColorSpaceRelease(cs);
 CGContextSetAllowsAntialiasing(ctx, 0);
 CGContextDrawImage(ctx, CGRectMake(0, 0, w, h), theCGImage);
 CGContextRelease(ctx);	
 
 CGImageRelease(theCGImage);
 */

/*
 CGColorSpaceRef cs = CGColorSpaceCreateDeviceGray();
 CGContextRef ctx = CGBitmapContextCreate(grayScale, heightOfImage, widthOfImage, 8, heightOfImage, cs, kCGImageAlphaNone);
 CGContextSetAllowsAntialiasing(ctx, 0);
 
 //ciContext = [CIContext contextWithCGContext:ctx options:nil];
 //[ciContext drawImage:anImage atPoint:CGPointZero fromRect:CGRectMake(0, 0, arect.size.width, arect.size.height)];
 
 CGIMageRef cgImage = CreateCGImageFromPixelBuffer()
 CGContextDrawImage(ctx, CGRectZero, cgImage)
 
 CGContextRelease(ctx);
 CGColorSpaceRelease(cs);
 */

@end
