
/* SampleCIView.h - simple OpenGL based CoreImage view */

// This code was stolen from /Developer/Examples/Quartz/Core Image/FunHouse/SampleCIView.m
// and modified to scale the CIImage within the frame rect (preserving aspect ratio,
// and painting unused areas black)

#import <Cocoa/Cocoa.h>
#import <QuartzCore/CoreImage.h>


@interface SampleCIView: NSOpenGLView
{
    CIContext *context;
    CIImage   *theImage;
    NSRect     lastBounds;
	CGSize     captureSize;
		
	BOOL mirrored, goodScan;
	BOOL cropImage;
	CGRect cropRect;
	
	//NSRecursiveLock         *lock;
	CIFilter *mirroredFilter, *redLinesFilter, *greenLinesFilter;
	BOOL captureMode;
	NSColor *defaultColor;
}

- (void)setImage:(CIImage *)image;
//- (void)setImage:(CIImage *)image dirtyRect:(CGRect)r;
//- (void)setCleanRect:(CGRect)cleanRect;
- (void)setCaptureSize:(CGSize)aSize;
- (void)setCropRect:(CGRect)cropRect;
//- (void)setDefaultColor:(NSColor *)aColor;


- (CIImage *)image;

// Called when the view bounds have changed
- (void)viewBoundsDidChange:(NSRect)bounds;

- (void)setGoodScan:(BOOL)aBool;
- (void)setMirrored:(BOOL)aBool;
//- (void)setHighResiSight:(BOOL)aBool;

- (void)setCapture:(BOOL)aMode;

@end