//
//  MyiSightWindow.m

#import "MyiSightWindow.h"
#import "MyBarcodeScanner.h"


@implementation MyiSightWindow


- (BOOL)canBecomeKeyWindow {
	return YES;
}


- (BOOL)performKeyEquivalent:(NSEvent *)theEvent {
	unichar characterHit = [[theEvent characters] characterAtIndex:0];
	//NSLog(@"%d", characterHit);
	if ( characterHit == 27 || characterHit == 127 || characterHit == 46 || characterHit == 'w') {
		//|| (characterHit == 32 && captureMode == NO)) { //esc, delete, period or w; space only for iSight
		[self performClose:self]; //Informs the delegate with windowShouldClose: to release the connection to the iSight
		return YES;
	}
	
	/*
	if (captureMode) {
		if (characterHit == 13 || characterHit == 32 ) { //enter, space
			id delegate = [self delegate];
			if ([delegate respondsToSelector:@selector(tooglePause:)]) {
				[delegate tooglePause:self];
				return YES;
			}
		}
		else if (characterHit == 'm') {
			id delegate = [self delegate];
			if ([delegate respondsToSelector:@selector(toggleMirroredImage)]) {
				[delegate toggleMirroredImage];
				return YES;
			}			
		} //enter
	}
	 */
	
	
#if DEBUG
	else {
		if (characterHit == 13) { //enter
			id delegate = [self delegate];
			if ([delegate respondsToSelector:@selector(setScanBarcode:)]) {
				[delegate setScanBarcode:YES];
				return YES;
			}
		}
	}
#endif DEBUG
		
	return [super performKeyEquivalent:theEvent];
}

- (void)mouseDown:(NSEvent *)theEvent {
	
	
#if DEBUG
		id delegate = [self delegate];
		if ([delegate respondsToSelector:@selector(setScanBarcode:)]) {
			[delegate setScanBarcode:YES];
		}
#endif DEBUG
	
	[super mouseDown:theEvent];
}


@end
