//
//  MyScanner.h
//  BarcodeScanner
//
//  Created by Nora Schmitt on 12/4/10.
//  Copyright 2010 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "SampleCIView.h"

@class MyGraphView;


@interface MyScanner : NSObject {
	int numberOfDigitsFound;
	int frameCount;
	//BOOL newHighResiSight;
	NSString *previousSingleFrameOldScan;
	SampleCIView *previewView;
	
	char numberArray[3][12], previousNumberLocalArray[3][12], previousNumberLocalArrayOLD[3][12];
	
	char globalFrequencyMatrix[10][13];
	
	//Use to limit the barcode scanning to only happening with a mouse click
#if DEBUG
	char previousNumberGlobalArray[3][12];
	MyGraphView *graphView, *barcodeView;
	//CVImageBufferRef bufferForProcess;
#endif DEBUG

	//int firstScanOffset;

	unsigned char *dataBuffer;
	NSInteger width, height;
	NSUInteger firstScanOffset;

}

- (id)initWithDataBuffer:(unsigned char *)grayScale height:(NSInteger)heightOfImage width:(NSInteger)widthOfImage;

- (NSString *)scan;
//- (NSString *)scanBuffer:(CVPixelBufferRef)pixelBuffer; 
- (void)clearGlobalFrequency;
- (void)setPreviewView:(SampleCIView *)aView;


@end
