//
//  BEMainWindowController.m
//  BooksExporter
//
//  Created by Hori,Masaki on 11/02/28.
//  Copyright 2011 masakih. All rights reserved.
//

#import "BEMainWindowController.h"
#import "MyBarcodeScanner.h"

#import "BEExportAccessoryViewController.h"
#import "BEBookInformation.h"
#import "BEAmazonLookup.h"

#import "BEBooksExporter.h"
#import "BEPreference.h"
#import "BEExporterAttribute.h"


@implementation BEMainWindowController

- (id)init
{
	self = [super initWithWindowNibName:@"BEMainWindow"];		
	return self;
}

- (void)awakeFromNib
{
	[books bind:NSManagedObjectContextBinding
	   toObject:self
	withKeyPath:@"managedObjectContext"
		options:nil];
}

#pragma mark-
- (void)lookupBooks:(NSArray *)array
{
	[[BEAmazonLookup sharedInstance] lookupBooks:array];
}
- (void)registerCategoryIfNeeded:(NSString *)category
{
	if(!category || [category length] == 0) return;
	
	NSUserDefaults *ud = [NSUserDefaults standardUserDefaults];
	NSMutableArray *categories = [ud objectForKey:@"categories"];
	if(!categories) categories = [NSArray array];
	if(![categories containsObject:category]) {
		categories = [categories mutableCopy];
		[categories addObject:category];
		[ud setObject:categories forKey:@"categories"];
		[categories release];
		categories = nil;
	}

}
- (void)openiSightContinous:(BOOL)flag
{
	NSUserDefaults *prefs = [NSUserDefaults standardUserDefaults];
	MyBarcodeScanner *iSight = [MyBarcodeScanner sharedInstance];
	[iSight setStaysOpen:flag];
	[iSight setDelegate:self];
	
	if ([[prefs objectForKey:@"Mirror iSight"] intValue])
		[iSight setMirrored:YES];
	else
		[iSight setMirrored:NO];
	
	[iSight scanForBarcodeWindow:nil];
}

- (BOOL)hasItemOfISBN:(NSString *)isbn
{
	NSFetchRequest *fetch = [[[NSFetchRequest alloc] init] autorelease];
	NSEntityDescription *entiry = [NSEntityDescription entityForName:[books entityName]
											  inManagedObjectContext:[books managedObjectContext]];
	[fetch setEntity:entiry];
	NSPredicate *predicate = [NSPredicate predicateWithFormat:@"isbn = %@", isbn];
	[fetch setPredicate:predicate];
	
	NSError *error = nil;
	NSUInteger count = [[books managedObjectContext] countForFetchRequest:fetch error:&error];
	if(error) {
		NSLog(@"%s Error : %@", __PRETTY_FUNCTION__, error);
		return NO;
	}
	return count != 0;
}

#pragma mark KVC
- (NSManagedObjectContext *)managedObjectContext
{
	return [[NSApp delegate] managedObjectContext];
}

- (NSArray *)status
{
	return [NSArray arrayWithObjects:
			NSLocalizedString(@"-", @"-"),
			NSLocalizedString(@"Want read", @"Want read"),
			NSLocalizedString(@"Now reading", @"Now reading"),
			NSLocalizedString(@"Already read", @"Already read"),
			NSLocalizedString(@"Stack", @"Stack"),
			nil];
}
- (BOOL)noteIfDuplicate
{
	return YES;
}

#pragma mark Actions
- (IBAction)openContinousScan:(id)sender
{
	//If option was held down, flip the mirrored preference value
	NSUserDefaults *prefs = [NSUserDefaults standardUserDefaults];
	if ([sender isKindOfClass:[NSButton class]]) {
		if ([[NSApp currentEvent] modifierFlags] & NSAlternateKeyMask) {
			int mirrorValue = ([[prefs objectForKey:@"Mirror iSight"] intValue] +1) %2;
			[prefs setObject:[NSNumber numberWithInt:mirrorValue] forKey:@"Mirror iSight"];
		}
	}
	[self openiSightContinous:YES];
}
- (IBAction)openSingleScan:(id)sender
{
	//If option was held down, flip the mirrored preference value
	NSUserDefaults *prefs = [NSUserDefaults standardUserDefaults];
	if ([sender isKindOfClass:[NSButton class]]) {
		if ([[NSApp currentEvent] modifierFlags] & NSAlternateKeyMask) {
			int mirrorValue = ([[prefs objectForKey:@"Mirror iSight"] intValue] +1) %2;
			[prefs setObject:[NSNumber numberWithInt:mirrorValue] forKey:@"Mirror iSight"];
		}
	}
	[self openiSightContinous:NO];
}

- (IBAction)lookupInformation:(id)sender
{
	[[BEAmazonLookup sharedInstance] lookupBooks:[books selectedObjects]];
}
- (IBAction)didChangeCategory:(id)sender
{
	NSString *selection = [sender stringValue];
	[self registerCategoryIfNeeded:selection];
}

- (IBAction)export:(id)sender
{
	[self.window endEditingFor:nil];
	
	NSSavePanel *panel = [NSSavePanel savePanel];
	if(!accessoryController) accessoryController = [[BEExportAccessoryViewController alloc] init];
	accessoryController.panel = panel;
	
	NSInteger res = 0;
	if([panel respondsToSelector:@selector(setNameFieldStringValue:)]) {
		[panel setNameFieldStringValue:@"Import.csv"];  // 10.6 only.
		res = [panel runModal];
	} else {
		res = [panel runModalForDirectory:nil file:@"Import.csv"];
	}
	if(res == NSCancelButton) return;
	
	BEBooksExporter *exporter = [BEBooksExporter exporterWithType:accessoryController.type];
	exporter.books = books.arrangedObjects;
	if([exporter exportToURL:[panel URL]] && ![BEPreference preference].doNotCheckExport) {
		[books setValue:[NSNumber numberWithBool:YES] forKeyPath:@"arrangedObjects.exported"];
	}
	
	NSWorkspace *ws = [NSWorkspace sharedWorkspace];
	[ws selectFile:[[panel URL] path] inFileViewerRootedAtPath:@""];

	BEExporterAttribute *attr = [BEExporterAttribute attributeByType:accessoryController.type];
	if(attr.isOpenAfterExport) {
		[ws openURL:attr.site.registerPageURL];
	}
}
- (IBAction)delete:(id)sender
{
	[books remove:sender];
}

- (BOOL)validateMenuItem:(NSMenuItem *)menuItem
{
	SEL action = [menuItem action];
	if(action == @selector(delete:)) {
		return [books canRemove];
	}
	return NO;
}

- (void)keyDown:(NSEvent *)theEvent
{
	NSString *chars = [theEvent charactersIgnoringModifiers];
	if([chars length] != 0 && [chars characterAtIndex:0] == NSDeleteCharacter) {
		if([books canRemove]) {
			[self delete:nil];
		}
		return;
	}
	[super keyDown:theEvent];
}

#pragma mark-
#pragma mark Delegate 
- (void)iSightWillClose
{
	[[self window] makeKeyAndOrderFront:self];
}
- (void)gotBarcode:(NSString *)barcode
{
	if([self hasItemOfISBN:barcode]) {
		if([self noteIfDuplicate]) {
			NSRunAlertPanel(NSLocalizedString(@"Duplicate", @"Duplicate"),
							NSLocalizedString(@"This book has already scan.", @"This book has already scan."),
							nil, nil, nil);
		}
		return;
	}
	BEBookInformation *book = [NSEntityDescription insertNewObjectForEntityForName:[books entityName]
															inManagedObjectContext:[books managedObjectContext]];
	book.isbn = barcode;
	if([BEPreference preference].autoLookUp) {
		[[BEAmazonLookup sharedInstance] lookupBook:book];
	}
	[books performSelector:@selector(setSelectedObjects:)
				withObject:[NSArray arrayWithObject:book]
				afterDelay:0.0001];
	[books prepareContent];
}

#pragma mark TableView Data Source
- (void)tableView:(NSTableView *)tableView setObjectValue:(id)object forTableColumn:(NSTableColumn *)tableColumn row:(NSInteger)row
{
	if([[tableColumn identifier] isEqualToString:@"Category"]) {
		[self registerCategoryIfNeeded:object];
	}
}

@end
