//
//  BEBooksExporter.m
//  BooksExporter
//
//  Created by Hori,Masaki on 11/02/28.
//  Copyright 2011 masakih. All rights reserved.
//

#import "BEBooksExporter.h"
#import "BEBookInformation.h"

#import "BEBooklogBooksExporter.h"
#import "BEMediaMarkerBooksExporter.h"
#import "BEMediaMarkerImportFormatExporter.h"
#import "BEHatenaDairyExporter.h"
#import "BEMonoColleExporter.h"


@implementation BEBooksExporter
@synthesize books;

+ (id)exporterWithType:(NSNumber *)type
{
	Class createClass = Nil;
	switch((ExporterType)[type intValue]) {
		case typeBooklogExport:
			createClass = [BEBooklogBooksExporter class];
			break;
		case typeMediaMarkerExport:
			createClass = [BEMediaMarkerBooksExporter class];
			break;
		case typeMediaMarkerImport:
			createClass = [BEMediaMarkerImportFormatExporter class];
			break;
		case typeHatenaDairyType:
			createClass = [BEHatenaDairyExporter class];
			break;
		case typeMonoColleExport:
			createClass = [BEMonoColleExporter class];
			break;
			
		default:
			NSLog(@"Unsupported export type.(%@)", type);
			return nil;
	}
	
	if(!createClass) return nil;
	
	return [[[createClass alloc] init] autorelease];
}
- (void)dealloc
{
	[books release];
	[lines release];
	[super dealloc];
}
- (BOOL)exportToURL:(NSURL *)url
{
	lines = [[NSMutableArray alloc] init];
	[self buildLines];
	if([lines count] == 0) {
		[lines release]; lines = nil;
		return NO;
	}
	
	NSString *string = [lines componentsJoinedByString:[self lineSeparator]];
	[lines release]; lines = nil;
	if([self needsNewLineAtEndOfFile]) {
		string = [string stringByAppendingString:[self lineSeparator]];
	}
	NSError *error = nil;
	BOOL isOK = NO;
	isOK = [string writeToURL:url atomically:YES encoding:[self fileEncoding] error:&error];
	if(!isOK) {
		NSString *errorString = nil;
		if(error) {
			errorString = [error localizedDescription];
		}
		NSLog(@"Error exporting -> %@", errorString);
		return NO;
	}
	return YES;
}

NSString *doubleQuoteQuotedString(NSString *string)
{
	if(!string) return @"";
	if([string isKindOfClass:[NSAttributedString class]]) {
		string = [(NSAttributedString *)string string];
	}
	return [string stringByReplacingOccurrencesOfString:@"\"" withString:@"\"\""];
}
NSString *tagsString(NSArray *tags)
{
	if(!tags) return @"";
	return [tags componentsJoinedByString:@" "];
}
NSString *normalizeString(NSString *string)
{
	if(!string) return @"";
	if([string isKindOfClass:[NSAttributedString class]]) {
		string = [(NSAttributedString *)string string];
	}
	return string;
}

// for subclass
- (void)buildLines
{
	for(BEBookInformation *book in books) {
		if(book.exported) continue;
		NSString *line = [self lineForBook:book];
		if(line) [lines addObject:line];
	}
}
- (NSString *)lineForBook:(BEBookInformation *)book { return nil; }
- (NSString *)lineSeparator { return @"\r\n"; }
- (NSStringEncoding)fileEncoding { return NSShiftJISStringEncoding; }
- (BOOL)needsNewLineAtEndOfFile { return NO; }

@end
