//
//  BEAmazonRequestGenerator.m
//  BooksExporter
//
//  Created by Hori,Masaki on 11/02/27.
//  Copyright 2011 masakih. All rights reserved.
//

#import "BEAmazonRequestGenerator.h"
#import "BEBookInformation.h"

#import <CommonCrypto/CommonHMAC.h>
#import "Base64EncDec.h"

#include "AmazonSecureKey.h"

NSString* encodeURIComponent(NSString* s) {
    return [((NSString*)CFURLCreateStringByAddingPercentEscapes(kCFAllocatorDefault,
																(CFStringRef)s,
																NULL,
																(CFStringRef)@"!*'();:@&=+$,/?%#[]",
																kCFStringEncodingUTF8)) autorelease];
}

@interface BEAmazonRequestGenerator (BEPrivate)
- (NSDictionary *)paramsForISBN:(NSString *)isbn;
@end

@implementation BEAmazonRequestGenerator
@synthesize book;

+ (id)generatorWithBook:(BEBookInformation *)aBook
{
	return [[[[self class] alloc] initWithBook:aBook] autorelease];
}
- (id)initWithBook:(BEBookInformation *)aBook
{
	self = [super init];
	if(self) {
		book = [aBook retain];
		timestampDateFormatter = [[NSDateFormatter alloc] init];
		[timestampDateFormatter setDateFormat:@"YYYY-MM-dd'T'HH':'mm':'ss'Z'"];
		endpoint = [[NSURL URLWithString:@"http://ecs.amazonaws.jp/onca/xml"] retain];
	}
	return self;
}
- (void)dealloc
{
	[sortedParamsPairs release];
	[book release];
	[timestampDateFormatter release];
	[endpoint release];
	[super dealloc];
}

- (void)setBook:(BEBookInformation *)newBook
{
	if([book isEqual:newBook]) return;
	[book autorelease];
	book = [newBook retain];
	[sortedParamsPairs release];
	sortedParamsPairs = nil;
}

- (NSURL *)endpoint
{
	return endpoint;
}

- (NSArray *)sortedParamsPairs
{
	if(sortedParamsPairs) return sortedParamsPairs;
	
	NSMutableDictionary *params = [NSMutableDictionary dictionary];
	[params setObject:@"AWSECommerceService" forKey:@"Service"];
	[params setObject:@"AKIAIRJSXONOXNMTGHDQ" forKey:@"AWSAccessKeyId"];
	[params setObject:@"mapr0e-22" forKey:@"AssociateTag"];
	[params setObject:@"2010-11-01" forKey:@"Version"];
	[params setObject:encodeURIComponent([timestampDateFormatter stringFromDate:[NSDate date]])
				  forKey:@"Timestamp"];
	
	[params setObject:@"ItemLookup" forKey:@"Operation"];
	
	[params setObject:@"ISBN" forKey:@"IdType"];
	[params setObject:@"Books" forKey:@"SearchIndex"];
	[params setObject:@"ItemAttributes" forKey:@"ResponseGroup"];
	
	[params setObject:book.isbn forKey:@"ItemId"];
	
	NSMutableArray *paramPairsArray = [NSMutableArray array];
	NSArray *keys = [[params allKeys] sortedArrayUsingSelector:@selector(compare:)];
	for(id key in keys) {
		[paramPairsArray addObject:[NSString stringWithFormat:@"%@=%@",
								  key,
								  [params objectForKey:key]]];
	}
	sortedParamsPairs = [[NSArray arrayWithArray:paramPairsArray] retain];
	return sortedParamsPairs;
}
- (NSString *)signature
{
	NSString *seed = [NSString stringWithFormat:@"GET\n%@\n%@\n%@",
					  [[self endpoint] host], [[self endpoint] path],
					  [[self sortedParamsPairs] componentsJoinedByString:@"&"]];
//	NSLog(@"Seed -> %@", seed);
	
	const char *cData = [seed cStringUsingEncoding:NSASCIIStringEncoding];
	unsigned char chmac[CC_SHA256_DIGEST_LENGTH];
	CCHmac(kCCHmacAlgSHA256, secureKey, strlen(secureKey), cData, strlen(cData), chmac);
	NSData *hash = [NSData dataWithBytes:chmac length:sizeof(chmac)];
	
	return encodeURIComponent([hash stringEncodedWithBase64]);
}
- (NSURLRequest *)request
{
	NSString *urlString = [NSString stringWithFormat:@"%@?%@&%@=%@",
						   [self endpoint],
						   [[self sortedParamsPairs] componentsJoinedByString:@"&"],
						   @"Signature", [self signature]];
//	NSLog(@"reques URL => %@", urlString);
	NSURL *url = [NSURL URLWithString:urlString];
	NSURLRequest *req = [NSURLRequest requestWithURL:url
										 cachePolicy:NSURLRequestUseProtocolCachePolicy
									 timeoutInterval:10.0];
	
	return req;
}

@end
