package com.tryjava.net;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

/**
 * URLエンコードを使ってみる。
 */
public class UrlEncodeJava {

	public static void main(String[] args) {
		new UrlEncodeJava().run();
	}

	public void run() {
		step01();
	}

	private void step01() {
		try {
			String encoded = URLEncoder.encode("https://www.tryjava.com/path/name?key1=value1&key2=おはよう#name", "UTF-8");
			System.out.println(encoded);

			String decoded = URLDecoder.decode(encoded, "UTF-8");
			System.out.println(decoded);

		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException(e);
		}
	}
}
