package com.tryjava.lang.stream;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * ストリームAPIを使ってみる。
 *
 * @since 2016/4/29
 */
public class Stream01 {
	private static List<String> list;

	public static void main(String[] args) {
		list = new ArrayList<String>();
		list.add("おはよう");
		list.add("こんにちは");
		list.add("こんばんは");

		// 従来の書き方
		step0a();
		step0b();

		// Java8での書き方
		step1();
	}

	/**
	 * 従来の書き方（Java1.4）
	 */
	private static void step0a() {
		long count = 0;
		@SuppressWarnings("rawtypes")
		Iterator ite = list.iterator();
		while (ite.hasNext()) {
			String str = (String) ite.next();
			if (str.length() > 4) {
				count++;
			}
		}
		System.out.println(count);
	}

	/**
	 * 従来の書き方（Java5）
	 */
	private static void step0b() {
		long count = 0;
		for (String e : list) {
			if (e.length() > 4) {
				count++;
			}
		}
		System.out.println(count);
	}

	/**
	 * Java8のストリームAPIによる書き方
	 */
	private static void step1() {
		long count = list.stream().filter(w -> w.length() > 4).count();
		System.out.println(count);
	}
}
