package com.tryjava.ext.xml;

import static org.hamcrest.CoreMatchers.*;
import static org.junit.Assert.*;

import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

import com.tryjava.ext.xml.Jaxb01;
import com.tryjava.ext.xml.Person;

public class Jaxb01Test {
	@Rule
	public TestName testName = new TestName();

	private Jaxb01 sut;

	@Before
	public void setUp() throws Exception {
		System.out.println("--- " + testName.getMethodName() + " ---");
		sut = new Jaxb01();
	}

	@Test
	public void testMarshal() {
		// 準備

		// 実行
		String actual = sut.marshal();

		// 検証
		String expected = "" //
				+ "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n" //
				+ "<person>\n" //
				+ "    <name>山田 太郎</name>\n" //
				+ "    <age>20</age>\n" //
				+ "</person>\n" //
				;
		assertThat(actual, is(expected));
	}

	@Test
	public void testUnmarshal() {
		// 準備

		// 実行
		Person actual = sut.unmarshal();

		// 検証
		assertThat(actual.name, is("山田 太郎"));
		assertThat(actual.age, is(20));
	}
}
