package com.tryjava.etc.junit.s18_1;

import static org.junit.Assert.*;
import static org.hamcrest.CoreMatchers.*;

import org.junit.experimental.theories.DataPoints;
import org.junit.experimental.theories.Theories;
import org.junit.experimental.theories.Theory;
import org.junit.runner.RunWith;

@RunWith(Theories.class)
public class StringUtilsTest2 {

	public static class Fixture {
		public String input;
		public String expected;

		public Fixture(String input, String expected) {
			this.input = input;
			this.expected = expected;
		}
	}

	@DataPoints
	public static Fixture[] fixtures = { new Fixture("", ""),
			new Fixture("aaa", "aaa"),
			new Fixture("HelloWorld", "hello_world"),
			new Fixture("practiceJunit", "practice_junit"), };

	@Theory
	public void testToStringCase(Fixture fixture) {
		// 準備
		String input = fixture.input;
		// 実行
		String actual = StringUtils.toSnakeCase(input);
		// 検証
		assertThat(actual, is(fixture.expected));
	}

}
