package com.tryjava.etc.fizzbuzz;

import static org.junit.Assert.*;
import static org.hamcrest.CoreMatchers.*;

import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.experimental.theories.DataPoints;
import org.junit.experimental.theories.Theories;
import org.junit.experimental.theories.Theory;
import org.junit.runner.RunWith;

import com.tryjava.etc.fizzbuzz.FizzBuzz;

@RunWith(Enclosed.class)
public class FizzBuzzTest {

	/**
	 * 正常系のテストケース群
	 */
	@RunWith(Theories.class)
	public static class NormalTest {

		public static class Fixture {
			public int input;
			public String expected;

			public Fixture(int input, String expected) {
				this.input = input;
				this.expected = expected;
			}
		}

		@DataPoints
		public static Fixture[] fixtures = { //
				new Fixture(1, "1"), //
				new Fixture(2, "1,2"), //
				new Fixture(3, "1,2,Fizz"), //
				new Fixture(5, "1,2,Fizz,4,Buzz"), //
				new Fixture(50, "1,2,Fizz,4,Buzz,Fizz,7,8,Fizz,Buzz"
						+ ",11,Fizz,13,14,FizzBuzz,16,17,Fizz,19,Buzz"
						+ ",Fizz,22,23,Fizz,Buzz,26,Fizz,28,29,FizzBuzz"
						+ ",31,32,Fizz,34,Buzz,Fizz,37,38,Fizz,Buzz"
						+ ",41,Fizz,43,44,FizzBuzz,46,47,Fizz,49,Buzz"), //
		};

		private FizzBuzz sut;

		@Before
		public void setUp() {
			sut = new FizzBuzz();
		}

		@Theory
		public void testGetMessage(Fixture fixture) {
			assertThat(sut.getMessage(fixture.input), is(fixture.expected));
		}

	}

	/**
	 * エラー系のテストケース群
	 */
	public static class ErrorTest {

		private FizzBuzz sut;

		@Before
		public void setUp() {
			sut = new FizzBuzz();
		}

		@Test(expected = IllegalArgumentException.class)
		public void testGetMessage_Zero() {
			sut.getMessage(0);
		}

		@Test(expected = IllegalArgumentException.class)
		public void testGetMessage_Minus() {
			sut.getMessage(-1);
		}
	}
}
