package com.tryjava.etc.fizzbuzz;

public class Argument {
	private int max = 50;
	private String error;

	public boolean set(String[] strings) {
		if (strings == null) {
			throw new IllegalArgumentException("引数が不正です。引数=null");
		}

		if (strings.length >= 2) {
			error = "引数の数が不正です。引数の数=" + strings.length;
			return false;
		}

		if (strings.length == 1) {
			if (parseMax(strings[0]) == false) {
				return false;
			}
		}

		return true;
	}

	private boolean parseMax(String string) {
		try {
			max = Integer.parseInt(string);
			if (max <= 0) {
				throw new NumberFormatException();
			}
		} catch (NumberFormatException e) {
			error = "引数が不正です。引数=" + string;
			return false;
		}
		return true;
	}

	public int getMax() {
		return max;
	}

	public String getError() {
		return error;
	}

}
