package com.tryjava.net;

import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.StringRequestEntity;

import com.tryjava.util.AppUtil;

/**
 * HTTPクライアントを作成してみる。（Apache Commons HttpClient 3.x）
 *
 * 色々な操作を試してみる。
 *
 * 参考<br>
 * HttpClient - HttpClient Tutorial
 * http://hc.apache.org/httpclient-3.x/tutorial.html<br>
 *
 * @since 2016/5/26
 */
public class ApacheHttpClient02 {

	public void run() {
		doGet();
		doPost();
		doPut();
	}

	void doGet() {
		System.out.println("--- " + AppUtil.getMethod() + " ---");

		// クライアント作成
		HttpClient client = new HttpClient();

		try {
			// リクエスト作成
			HttpMethod method = new GetMethod("http://localhost:8080/tryjava-dummy-web/echo");
			// クエリ―文字列は、URLエンコードされる。
			// UTF-8以外を使いたいときは、EncodingUtilを使うらしい。
			// TODO 日本語の設定は、これでよい？
			method.setQueryString(new NameValuePair[] { //
					new NameValuePair("param1", "value1"), //
					new NameValuePair("UrlEncode", "+-/_"), //
					new NameValuePair("text", "日本語"), //
			});
			// ヘッダー設定
			method.addRequestHeader("Accept-Language", "ja");
			method.addRequestHeader("X-Header1", "value1");

			try {
				// 接続
				int statusCode = client.executeMethod(method);
				System.out.println("statusCode=" + statusCode);
				if (statusCode != HttpStatus.SC_OK) {
					throw new RuntimeException("エラーレスポンスを受信しました。statusCode=" + statusCode);
				}

				// レスポンスヘッダ取得
				Header[] headers = method.getResponseHeaders();
				for (int i = 0; i < headers.length; i++) {
					System.out.print(headers[i]);
				}

				// レスポンスボディ取得
				byte[] responseBody = method.getResponseBody();
				System.out.println();
				System.out.println(new String(responseBody, "UTF-8"));

			} finally {
				method.releaseConnection();
			}
		} catch (Exception e) {
			throw new RuntimeException("HTTP通信に失敗しました。", e);
		}
	}

	void doPost() {
		System.out.println("--- " + AppUtil.getMethod() + " ---");

		// クライアント作成
		HttpClient client = new HttpClient();

		// リクエスト作成
		PostMethod method = new PostMethod("http://localhost:8080/tryjava-dummy-web/echo");
		// POSTパラメータ
		// POSTパラメータは、URLエンコードされる。
		method.getParams().setContentCharset("UTF-8");
		method.setRequestBody(new NameValuePair[] { //
				new NameValuePair("param1", "value1"), //
				new NameValuePair("UrlEncode", "+-/_"), //
				new NameValuePair("text", "日本語"), //
		});
		// 次の書き方でも良い。
		// method.addParameter("param1", "value1");
		// method.addParameter("UrlEncode", "+-/_");
		// method.addParameter("text", "日本語");
		// ヘッダー設定
		method.addRequestHeader("Accept-Language", "ja");
		method.addRequestHeader("X-Header1", "value1");

		try {
			// 接続
			int statusCode = client.executeMethod(method);
			System.out.println("statusCode=" + statusCode);
			if (statusCode != HttpStatus.SC_OK) {
				throw new RuntimeException("エラーレスポンスを受信しました。statusCode=" + statusCode);
			}

			// レスポンスヘッダ取得
			Header[] headers = method.getResponseHeaders();
			for (int i = 0; i < headers.length; i++) {
				System.out.print(headers[i]);
			}

			// レスポンスボディ取得
			byte[] responseBody = method.getResponseBody();
			System.out.println();
			System.out.println(new String(responseBody, "UTF-8"));

		} catch (Exception e) {
			throw new RuntimeException("HTTP通信に失敗しました。", e);
		} finally {
			method.releaseConnection();
		}
	}

	void doPut() {
		System.out.println("--- " + AppUtil.getMethod() + " ---");

		try {
			// クライアント作成
			HttpClient client = new HttpClient();

			// リクエスト作成
			PutMethod method = new PutMethod("http://localhost:8080/tryjava-dummy-web/echo");
			// パラメータ
			method.getParams().setContentCharset("UTF-8");
			method.setRequestEntity(new StringRequestEntity("{" //
					+ "\"param1\":\"value1\"" //
					+ "\"UrlEncode\":\"+-/_\"" //
					+ "\"text\":\"日本語\" //" //
					+ "}", null, "UTF-8"));
			// ヘッダー設定
			method.addRequestHeader("Accept-Language", "ja");
			method.addRequestHeader("X-Header1", "value1");

			try {
				// 接続
				int statusCode = client.executeMethod(method);
				System.out.println("statusCode=" + statusCode);
				if (statusCode != HttpStatus.SC_OK) {
					throw new RuntimeException("エラーレスポンスを受信しました。statusCode=" + statusCode);
				}

				// レスポンスヘッダ取得
				Header[] headers = method.getResponseHeaders();
				for (int i = 0; i < headers.length; i++) {
					System.out.print(headers[i]);
				}

				// レスポンスボディ取得
				byte[] responseBody = method.getResponseBody();
				System.out.println();
				System.out.println(new String(responseBody, "UTF-8"));
			} finally {
				method.releaseConnection();
			}

		} catch (Exception e) {
			throw new RuntimeException("HTTP通信に失敗しました。", e);
		}
	}
}
