package com.tryjava.io.file;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;

/**
 * テキストファイル読み書きの練習
 *
 * Apache Commons について
 * <ul>
 * <li>Apache Commons IO 2.4 では、Java6以上が必要。
 * <li>Apache Commons IO 2.0 では、Java5以上が必要。
 * <li>Java1.4では、Apache Commons IO 1.x 以下が使用可能。
 * </ul>
 * <ul>
 * <li>Apache Commons Lang 3.2 では、Java6以上が必要。
 * <li>Apache Commons Lang 3.0 では、Java5以上が必要。
 * <li>Java1.4では、Apache Commons Lang 2.x 以下が使用可能。
 * </ul>
 *
 * 参考
 * <ul>
 * <li>Javaで1行ずつテキストデータを読み込むイディオムの変遷 - argius note<br>
 * http://argius.hatenablog.jp/entry/2015/06/06/234315
 * </ul>
 *
 * @sine 2016/5/2
 */
public class TextFileCommons01 {
	static final String path = "./work/text-file-commons-01.txt";

	public static void main(String[] args) {
		TextFileCommons01 app = new TextFileCommons01();
		app.run();
	}

	void run() {
		writeAll();
		readAll();
	}

	/**
	 * Apache Commons IOでのテキストファイル書き込み
	 */
	void writeAll() {
		// リストからファイル書き込み
		List lines = new ArrayList();
		lines.add("Hello Apache Commons IO");
		try {
			FileUtils.writeLines(new File(path), "UTF-8", lines, SystemUtils.LINE_SEPARATOR);
		} catch (IOException e) {
			e.printStackTrace();
		}

		// 文字列からファイル書き込み
		String text = "Hello Apache Commons IO\n" + "サンプルテキスト\n";
		try {
			FileUtils.writeStringToFile(new File(path), text, "UTF-8");
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	/**
	 * Apache Commons IOでのテキストファイル読み込み
	 */
	void readAll() {
		// ファイルからリストへ読み込み
		try {
			List lines = FileUtils.readLines(new File(path), "UTF-8");
			System.out.println(StringUtils.join(lines, SystemUtils.LINE_SEPARATOR));
		} catch (IOException e) {
			e.printStackTrace();
		}

		// ファイルから文字列へ読み込み
		try {
			String text = FileUtils.readFileToString(new File(path), "UTF-8");
			System.out.println(text);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
