package com.tryjava.lang.lambda;

import java.util.Arrays;
import java.util.Comparator;

import org.apache.commons.lang3.StringUtils;

/**
 * ラムダ式を使ってみる。
 *
 * Java標準APIで用意されているラムダ式受け入れ可能なメソッドを呼び出す。
 *
 * @since 2016/4/20
 */
public class Lambda01 {
	public static void main(String[] args) {
		// 従来の書き方
		step0();

		// Java8での書き方
		step1();
		step2();
	}

	/**
	 * 従来の書き方
	 */
	public static void step0() {
		String[] arr = createData();
		Arrays.sort(arr, new Comparator<String>() {
			@Override
			public int compare(String arg1, String arg2) {
				return arg1.compareTo(arg2);
			}
		});
		System.out.println(StringUtils.join(arr, ","));
	}

	/**
	 * ラムダ式による書き方
	 */
	public static void step1() {
		String[] arr = createData();
		Arrays.sort(arr, (arg1, arg2) -> {
			return arg1.compareTo(arg2);
		});
		System.out.println(StringUtils.join(arr, ","));
	}

	/**
	 * ラムダ式にメソッド参照を使った書き方
	 */
	public static void step2() {
		String[] arr = createData();
		SimpleComparator comparator = new SimpleComparator();
		Arrays.sort(arr, comparator::compare);
		System.out.println(StringUtils.join(arr, ","));
	}

	/**
	 * テストデータを作成する。
	 *
	 * @return テストデータ
	 */
	private static String[] createData() {
		return new String[] { "Java", "Ruby", "JavaScript", "Node.js", "C#" };
	}
}
