package com.tryjava;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class AppConfig {
	private static final String BUNDLE_NAME = "app"; //$NON-NLS-1$

	private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME);

	private AppConfig() {
	}

	public static String getString(String key) {
		try {
			return RESOURCE_BUNDLE.getString(key);
		} catch (MissingResourceException e) {
			return '!' + key + '!';
		}
	}

	public static int getInt(String key) {
		return Integer.valueOf(getString(key));
	}
}
