package com.tryjava.etc.junit.s19_2;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class Employee {
	public String firstName;
	public String lastName;
	public String email;

	public static List<Employee> load(InputStream is) {
		List<Employee> list = new ArrayList<Employee>();
		BufferedReader br = new BufferedReader(new InputStreamReader(is));
		try {
			while (true) {
				String line = br.readLine();
				if (line == null) {
					break;
				}
				String[] columns = line.split(",");
				Employee employee = new Employee();
				employee.firstName = columns[0];
				employee.lastName = columns[1];
				employee.email = columns[2];
				list.add(employee);
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
		return list;
	}

	public String toString() {
		return firstName + "," + lastName + "," + email;
	}
}
