package com.tryjava.net;

import org.apache.http.client.fluent.Content;
import org.apache.http.client.fluent.Form;
import org.apache.http.client.fluent.Request;

import com.tryjava.util.AppUtil;

/**
 * HTTPクライアントを作成してみる。（Apache HttpComponents Fluent API）
 *
 * 参考<br>
 * JavaでのHttpClientサンプル - CLOVER
 * http://d.hatena.ne.jp/Kazuhira/20131026/1382796711<br>
 * Apache HttpComponents - HttpClient Quick Start
 * http://hc.apache.org/httpcomponents-client-4.5.x/quickstart.html<br>
 * Chapter 5. Fluent API
 * http://hc.apache.org/httpcomponents-client-ga/tutorial/html/fluent.html<br>
 *
 * @since 2016/5/26
 */
public class ApacheHttpClientFluent01 {

	public void run() {
		doGet();
		doPost();
	}

	void doGet() {
		System.out.println("--- " + AppUtil.getMethod() + " ---");

		try {
			Content content = Request.Get("http://localhost:8080/tryjava-dummy-web/echo").execute().returnContent();
			System.out.println(content.asString());

		} catch (Exception e) {
			throw new RuntimeException("HTTP通信に失敗しました。", e);
		}
	}

	void doPost() {
		System.out.println("--- " + AppUtil.getMethod() + " ---");

		try {
			Content content = Request.Post("http://localhost:8080/tryjava-dummy-web/echo")
					.bodyForm(Form.form().add("username", "my-name").add("password", "my-password").build()).execute()
					.returnContent();
			System.out.println(content.asString());

		} catch (Exception e) {
			throw new RuntimeException("HTTP通信に失敗しました。", e);
		}
	}
}
