package com.tryjava.net;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.GetMethod;

import com.tryjava.util.AppUtil;

/**
 * HTTPクライアントを作成してみる。（Apache Commons HttpClient 3.x）
 *
 * まずはシンプルにアクセスしてみる。
 *
 * 参考<br>
 * HttpClient - HttpClient Tutorial
 * http://hc.apache.org/httpclient-3.x/tutorial.html<br>
 *
 * @since 2016/5/26
 */
public class ApacheHttpClient01 {

	public void run() {
		doGet();
	}

	void doGet() {
		System.out.println("--- " + AppUtil.getMethod() + " ---");

		// クライアント作成
		HttpClient client = new HttpClient();

		// リクエスト作成
		HttpMethod method = new GetMethod("http://localhost:8080/tryjava-dummy-web/echo");

		try {
			// 接続
			int statusCode = client.executeMethod(method);
			System.out.println("statusCode=" + statusCode);
			if (statusCode != HttpStatus.SC_OK) {
				throw new RuntimeException("エラーレスポンスを受信しました。statusCode=" + statusCode);
			}

			// レスポンスボディ取得
			byte[] responseBody = method.getResponseBody();
			System.out.println(new String(responseBody, "UTF-8"));

		} catch (Exception e) {
			throw new RuntimeException("HTTP通信に失敗しました。", e);
		} finally {
			method.releaseConnection();
		}
	}
}
